<?php

namespace App\Http\Controllers\Admin;

use App\Models\Crontab;
use App\Models\User;
use App\Models\ViewTask;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ViewTaskController extends Controller
{


    public  function  readBrushOne(Request $request)
    {
        $data = $request->all();

      /*  $query = ViewTask::where('type',1)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','view');
        })->with('crontab')->with('speed');*/
        $query = ViewTask::where('type',1)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed');
        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);
        //dd($page);
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.ViewTask.readBrushOne',compact('page','data'));
    }

    public  function readBrushTwo(Request $request)
    {
        $data = $request->all();
      /*  $query = ViewTask::where('type',2)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','view');
        })->with('crontab')->with('speed');*/

        $query = ViewTask::where('type',2)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed');

        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);

        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.ViewTask.readBrushTwo',compact('page','data'));
    }

    public  function readBrushThree(Request $request)
    {
        $data = $request->all();
        /*$query = ViewTask::where('type',3)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','view');
        })->with('crontab')->with('speed');*/
        $query = ViewTask::where('type',3)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed');
        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);

        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.ViewTask.readBrushThree',compact('page','data'));
    }

    public  function readRealPerson(Request $request)
    {
        $data = $request->all();
       /* $query = ViewTask::where('type',4)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','view');
        })->with('crontab')->with('speed');*/
        $query = ViewTask::where('type',5)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed');
        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);

        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.ViewTask.readRealPerson',compact('page','data'));
    }

    /**
     * 描述：修改栏目
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($id)
    {
        $show = ViewTask::where('id',$id)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed')->first();
        return view('Admin.ViewTask.edit',compact('show'));
    }
    /**
     * 描述：提交修改
     * @param Request $request
     */
    public  function  update(Request $request,$id)
    {

        $show = ViewTask::where('id',$id)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed')->first();
        //任务表的数据
        $crontab['pay_status'] = $request->pay_status ? $request->pay_status : ($show->crontab ?  $show->crontab->pay_status : 0);

        $crontab['status'] = $request->status ? $request->status :($show->crontab ?  $show->crontab->status : 0);
        $crontab['price'] = $request->price ? $request->price : ($show->crontab ?  $show->crontab->price : 0);
        //发布表的数据
        $data['title'] = $request->title ? $request->title : $show->title;
        $data['url'] = $request->url ? $request->url : $show->url;
        $data['require_views'] = $request->require_views ? $request->require_views : $show->require_views;
        $data['status'] = $request->status ? $request->status :  $crontab['pay_status'];
        $view_result = ViewTask::where('id',$id)->update($data);
        if($request->accept_uid)
        {
            $accept_id = User::where('mobile',$request->accept_uid)->first(['id'])->id;
            $data['accept_uid'] =$accept_id;
            if(Crontab::where('task_id',$id)->first())
            {
                $cron_result = Crontab::where('id',$show->crontab->id)->update($crontab);
            }else{
                $crontab['task_id'] = $id;
                $cron_result = Crontab::create($crontab);
            }
        }else{
            $cron_result = true;
        }
        if($view_result && $cron_result)
        {
            $this->set('code',0);
            $this->set('message','修改成功');
        }else
        {
            $this->set('code',1);
            $this->set('message','修改失败');
        }
        return $this->ajaxResponse();
    }

    /**
     * 描述：单条删除评论
     * @param Request $request
     * @return array
     */
    public  function  destroy(Request $request)
    {
        $id = $request->input('id');
        $query = ViewTask::where('id',$id)->delete();
        if($query)
        {
            Crontab::where('task_id',$id)->where('task_type','view')->delete();
            $this->set('code',0);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 1);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }



}
