<?php

namespace App\Http\Controllers\Admin;

use App\Models\Crontab;
use App\Models\User;
use App\Models\WeChatTask;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class WeChatTaskController extends Controller
{
    /**
     * 描述:微信僵尸粉
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  index(Request $request)
    {
        $data = $request->all();
       /* $query = WeChatTask::where('type',2)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','weixin');
        })->with('crontab');*/
        $query = WeChatTask::where('type',2)->with('userInfo')->with('acceptInfo')->with('crontab');
        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.WeChatTask.index',compact('page','data'));
    }

    /**
     * 描述:微信扫码加僵尸粉
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  wechatScanFans(Request $request)
    {
        $data = $request->all();
      /*  $query = WeChatTask::where('type',3)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','weixin');
        })->with('crontab');*/
        $query = WeChatTask::where('type',3)->with('userInfo')->with('acceptInfo')->with('crontab');
        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.WeChatTask.wechatScanFans',compact('page','data'));
    }

    /**
     * 描述:微信扫码加僵尸粉
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  realPersonFens(Request $request)
    {
        $data = $request->all();
       /* $query = WeChatTask::where('type',4)->with('userInfo')->with('acceptInfo')->whereHas('crontab', function ($query) {
            $query->where('task_type','weixin');
        })->with('crontab');*/
        $query = WeChatTask::where('type',4)->with('userInfo')->with('acceptInfo')->with('crontab');
        if(isset($data['start']))
        {
            $query =$query->where('created_at','>=',$data['start']);
        }
        if(isset($data['end']))
        {
            $query =$query->where('created_at','<=',$data['end']);
        }
        $page =$query->orderBy('id','desc')->paginate(20);
        $data['start'] = isset($data['start'])? $data['start'] : '';
        $data['end'] = isset($data['end'])? $data['end'] : '';
        return view('Admin.WeChatTask.realPersonFens',compact('page','data'));
    }





    /**
     * 描述：修改栏目
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($id)
    {
        $show = WeChatTask::where('id',$id)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed')->first();
        return view('Admin.WeChatTask.edit',compact('show'));
    }
    /**
     * 描述：提交修改
     * @param Request $request
     */
    public  function  update(Request $request,$id)
    {

        $show = WeChatTask::where('id',$id)->with('userInfo')->with('acceptInfo')->with('crontab')->with('speed')->first();
        //任务表的数据
        $crontab['pay_status'] = $request->pay_status ? $request->pay_status : ($show->crontab ?  $show->crontab->pay_status : 0);

        $crontab['status'] = $request->status ? $request->status :($show->crontab ?  $show->crontab->status : 0);
        $crontab['price'] = $request->price ? $request->price : ($show->crontab ?  $show->crontab->price : 0);
        //发布表的数据
        $data['title'] = $request->title ? $request->title : $show->title;
        $data['url'] = $request->url ? $request->url : $show->url;
        $data['require_likes'] = $request->require_likes ? $request->require_likes : $show->require_likes;
        $data['status'] = $request->status ? $request->status :  $crontab['pay_status'];
        $view_result = WeChatTask::where('id',$id)->update($data);
        if($request->accept_uid)
        {
            $accept_id = User::where('mobile',$request->accept_uid)->first(['id'])->id;

            if(Crontab::where('wechat_id',$id)->first())
            {
                dd(1);
                $cron_result = Crontab::where('id',$show->crontab->id)->update($crontab);
            }else{
                $crontab['wechat_id'] = $id;
                $cron_result = Crontab::create($crontab);
            }
        }else{
            $cron_result = true;
        }

        if($view_result && $cron_result)
        {
            $this->set('code',0);
            $this->set('message','修改成功');
        }else
        {
            $this->set('code',1);
            $this->set('message','修改失败');
        }
        return $this->ajaxResponse();
    }


    /**
     * 描述：单条删除评论
     * @param Request $request
     * @return array
     */
    public  function  destroy(Request $request)
    {
        $id = $request->input('id');
        $query = WeChatTask::where('id',$id)->delete();
        if($query)
        {
            Crontab::where('task_id',$id)->where('task_type','weixin')->delete();
            $this->set('code',0);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 1);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }



}
