<?php

namespace App\Http\Controllers\NewAdmin;

use App\Models\AdminUser;
use function GuzzleHttp\Promise\all;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
class LoginController extends Controller
{
    use AuthenticatesUsers;
    //登录页面
    public  function  index()
    {

        if(Session('admin.id'))
        {
            $info = Session('admin.username');
            return view('NewAdmin.Index.index',compact('info'));
        }
        return view('NewAdmin.Login.login');
    }
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * 登录成功
     */
    public function checkLogin(Request $request){
        $validators = Validator::make($request->all(),[
            'mobile'=>'required',
            'password'=>'required|min:5|max:20',
            'captcha'=>'required'
        ]);
        if(!$validators->fails())
        {
            $user = AdminUser::where(['username'=>$request->mobile])->where(['status'=>1])->first();
            if($user) {
                if(Auth::guard('admin')->attempt(['username' => $request->mobile, 'password' => $request->password])) {
                    Session::put('admin.username',$user->username);
                    Session::put('admin.id',$user->id);
                    Session::save();

                    $info = Session('admin.username');
                    return view('NewAdmin.Index.index',compact('info'));
                }else {
                    return redirect()->back()->with('status', '密码不正确');
                }
            }else{
                return redirect()->back()->with('status', '手机号未注册');
            }
        }else{
            return redirect()->back()->with('status', '验证码不正确');
        }
    }


    /**
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     * 退出
     */
    public function logout(){
        Session::flush();
        return redirect('newadmin/login');
    }
}
