<?php

namespace App\Http\Controllers\NewAdmin;

use App\Models\Category;
use App\Models\Crontab;
use App\Models\Setting;
use App\Models\TrillTask;
use App\Models\User;
use function GuzzleHttp\Promise\all;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TrillTaskController extends Controller
{
    public  function date(Request $request)
    {
        $model = TrillTask::where('type',$request->input('type'))->with('speed');
        if ($request->get('id')){
            $model = $model->where('id',$request->get('id'));
        }
        if ($request->get('trill_id')){
            $model = $model->where('trill_id',$request->get('trill_id'));;
        }

        if ($request->get('url')){
            $model = $model->where('url','like','%'.$request->get('url').'%');
        }

        if ($request->get('status')  && $request->get('status') != null){
            $model = $model->where('status',$request->get('status'));
        }
        $res = $model->orderBy('created_at','desc')->paginate($request->get('limit',30))->toArray();
        $data = [
            'code' => 0,
            'msg'   => '正在请求中...',
            'count' => $res['total'],
            'data'  => $res['data']
        ];
        return response()->json($data);
    }
    /**
     * 描述：任务修改
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  edit($id)
    {
        $info = TrillTask::with('userInfo')->with('acceptInfo')->with('crontab')->find($id);
        if($info->type == 1)
        {
            $cate = Category::where('key','trill_fans')->first();
            $rout = "admin.trill.fans";
        }elseif($info->type == 2){
            $cate = Category::where('key','trill_like')->first();
            $rout = "admin.trill.like";
        }elseif($info->type == 3){
            $cate = Category::where('key','trill_comment')->first();
            $rout = "admin.trill.comment";
        }elseif($info->type == 4){
            $cate = Category::where('key','trill_transmit')->first();
            $rout = "admin.trill.transmit";
        } elseif($info->type == 5){
            $cate = Category::where('key','trill_watch')->first();
            $rout = "admin.trill.watch";
        }
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('NewAdmin.Trill.edit',compact('info','speeds','rout'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $trill= TrillTask::findOrFail($request->input('id'));
        $price = Setting::where('id',$trill->speed_id)->first(['value'])->value;
        $mobile = $request->input('mobile');

        $accept_data=[];
        $accept_data['pay_status'] = $request->input('pay_status');
        $rout = $request->input('route');

        $data['trill_id'] = $request->input('trill_id');
        $data['require_like'] = $request->input('require_like');
        $data['speed_id'] = $request->input('speed_id');
        $data['content'] = $request->input('content');
        $data['status'] = $request->input('status');
        $data['price']   = $data['require_like'] * $price /100;
        if($trill->accept_uid)
        {
            if( $accept_data['pay_status'] == 1)
            {
                $accept_data['complete_time'] = date('Y-m-d H:i:s',time());
            }
            Crontab::where(['type'=>3,'task_id'=>$trill->id])->update($accept_data);
        }else{
            $accept_info = User::where('mobile',$mobile)->first();
            if(!$accept_info)
            {
                return redirect()->to(route($rout))->withErrors('接单用户不存在');
            }
            $accept_data['accept_time'] = $request->input('pay_status');
            $accept_data['task_id'] = $request->input('id');
            $accept_data['type'] = 3;
            $accept_data['status'] = 1;
            $accept_data['price'] = $data['price'];
            $accept_data['accept_time'] = date('Y-m-d H:i:s',time());
            Crontab::create($accept_data);
            $data['accept_uid'] = $accept_info->id;
        }
        if ($trill->update($data)){
            return redirect()->to(route($rout))->with(['status'=>'更新成功']);
        }
        return redirect()->to(route($rout))->withErrors(['status'=>'系统错误']);
    }
    /**
     * 描述：单条删除
     * @param Request $request
     * @return array
     */
    public  function  destroy(Request $request)
    {
        $id = $request->input('id');
        $query = TrillTask::where('id',$id)->delete();
        if($query)
        {
            $this->set('code',1);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 0);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }
    /**
     * 描述：粉丝
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillFans()
    {
        return view('NewAdmin.Trill.trillFans');
    }
    /**
     * 描述：点赞
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillLike()
    {
        return view('NewAdmin.Trill.trillLike');
    }
    /**
     * 描述：评论
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillComment()
    {
        return view('NewAdmin.Trill.trillComment');
    }
    /**
     * 描述：转发
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillTransmit()
    {

        return view('NewAdmin.Trill.trillTransmit');
    }
    /**
     * 描述：观看量
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillWatch()
    {
        return view('NewAdmin.Trill.trillWatch');
    }




















}
