<?php

namespace App\Http\Controllers\Web;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{

    //登录页面
    public  function  index()
    {
        return view('Home.Member.login');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * 登录成功
     */
    public function checkLogin(Request $request){
        $validators = Validator::make($request->all(),[
                'mobile'=>'required|min:1|max:11',
                'password'=>'required|min:6|max:20',
                'captcha'=>'required'
            ]);
        if(!$validators->fails())
        {
            $exist = User::where(['mobile'=>$request->mobile])->first();
            if($exist) {
                if (Auth::guard('web')->attempt(['mobile' => $request->mobile, 'password' => $request->password])) {
                    $info = User::where(['mobile' => $request->mobile])->first();
                    Session::put('member.user.id', $info->id);
                    Session::put('member.user.mobile', $request->mobile);
                    Session::save();
                    return view('Home.Index.index', compact('info'));
                } else {
                    return redirect()->back()->with('status', '密码不正确');
                }
            }else{
                return redirect()->back()->with('status', '手机号未注册');
            }
        }else{
            return redirect()->back()->with('status', '验证码不正确');
        }
    }


    /**
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     * 退出
     */
    public function logout(){
        Session::flush();
        return redirect('login');
    }

}
