<?php

namespace App\Http\Controllers\Web;

use App\Models\Category;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class MemberController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * 资料
     */
    public function index(){
        $info = User::with(['recharge'=>function($query){
            $query->select(['uid','id']);
        }])
            ->find(Session::get('member.user.id'),['id','username','mobile','name','email','agent_id','sex','remark']);
        return view('Home.Member.profile',compact('info'));
    }

    /**
     * 资料提交
     */
    public function store(Request $request){
        $info = User::find(Session::get('member.user.id'));
        $info->username = $request->nickname;
        $info->sex = $request->sex;
        $info->email = $request->email;
        $info->remark = $request->remarks;
        $info->save();
        return redirect()->back()->with('status', '修改成功');
        /*******/

    }

    /**
     * 修改密码视图
     */
    public function pass(){
        return view('Home.Member.modify');
    }


    public function password(Request $request){
        $mobile = User::find(Session::get('member.user.id'));
        if($request->password == $request->repassword){
            if(Auth::guard('web')->attempt(['mobile' => $mobile->mobile, 'password' => $request->oldPassword]))
            {
                $mobile->password = bcrypt($request->password);
                $update = $mobile->save();
                if($update){
                    return redirect()->back()->with('status', '修改成功');
                }else{
                    return redirect()->back()->with('status', '系统错误，请稍后再试');
                }
            }else{
                return redirect()->back()->with('status', '旧密码不正确');
            }
        }else{
            return redirect()->back()->with('status', '两次输入密码不一致');
        }
    }

}
