<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/23
 * Time: 1:10
 */

namespace App\Http\Controllers\Home\Advert;


use App\Http\Controllers\Controller;
use App\Models\OrderLog;
use App\Models\OrderPaylog;
use App\Models\Recharge;
use App\Traits\AjaxResponse;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Yansongda\Pay\Log;
use Yansongda\Pay\Pay;

class PayController extends Controller
{
    use AjaxResponse;
    public $config;
    /**
     * @param Request $request
     * 获取下单信息
     */
    public function pay($id){

        $info = Recharge::find($id);
        if($info->way == 'alipay'){
            $this->aliPay($info);
        }elseif($info->way == 'wechat'){
            $result = $this->wechatPay($info);
            $no = $info['order_no'];
            return view('Home.pay',compact('result','no'));
        }
    }

    /**
     * 会员订单信息保存
     */
    public function store(Request $request){
       //创建会员充值订单
        //返回订单id，开始支付流程
        $validates = Validator::make($request->all(),[
           'amount'=>'required',
            'way'=>'required'
        ]);
        if(!$validates->fails())
        {
            $exist = Recharge::where(['uid'=>$request->uid,'way'=>$request->way,'amount'=>$request->amount,'status'=>Recharge::WAIT_PAY,'title'=>'test'])
                ->where('expire_time','<',time())
                ->first();
            if($exist){
                $this->set('data',['id'=>$exist->id,'way'=>$request->way]);
            }
            else{
                $data = $request->all();
                $order_no = $out_trade_no = date("YmdHis"); //拼一下订单号
                $data['expire_time'] = time() + 86400;
                $data['order_no'] = $order_no;//订单号
                $insert = Recharge::create($data);
                if($insert){
                    $this->set('data',['id'=>$insert->id,'way'=>$request->way]);
                }
                else{
                    $this->set('msg','操作失败了，请再次提交');
                    $this->set('status',100);
                }
            }
        }else{
            $this->set('msg','操作失败了，请再次提交');
            $this->set('status',100);
        }
        return $this->ajaxResponse();
    }

    /**
     * @return \Yansongda\Pay\Gateways\Alipay\WebGateway
     * 支付宝
     */
    public function aliPay($orderInfo){
        $order = [
            'out_trade_no' => $orderInfo['order_no'],
//            'total_amount' => $orderInfo['amount'],//元
            'total_amount' => 0.01,//元
            'subject' => 'test--1',
        ];
        $this->config = config('pay.alipay');
        return Pay::alipay($this->config)->web($order)->send();
    }

    /**
     * 支付宝同步回调
     */
    public function aliReturn()
    {
        $this->config = config('pay.alipay');
        return Pay::alipay($this->config)->verify(); // 是的，验签就这么简单！*/
        // 订单号：$data->out_trade_no
        // 支付宝交易号：$data->trade_no
        // 订单总金额：$data->total_amount
    }

    /**
     * @return 支付宝异步回调
     */
    public function aliNotify(Request $request)
    {
        \Illuminate\Support\Facades\Log::info('--aliNotify--');
        \Illuminate\Support\Facades\Log::info(json_encode($request->all()));
        $this->config = config('pay.alipay');
        $alipay = Pay::alipay($this->config);

        try{
            $data = $alipay->verify(); // 是的，验签就这么简单！
            Log::debug('extra log start', []);
            Log::debug('header:', [$request->header()]);
            Log::debug('content:', [$request->all()]);
            Log::debug('extra log end', []);

            Log::debug('alipay', $data->all());
            // 请自行对 trade_status 进行判断及其它逻辑进行判断，在支付宝的业务通知中，只有交易通知状态为 TRADE_SUCCESS 或 TRADE_FINISHED 时，支付宝才会认定为买家付款成功。
            // 1、商户需要验证该通知数据中的out_trade_no是否为商户系统中创建的订单号；
            // 2、判断total_amount是否确实为该订单的实际金额（即商户订单创建时的金额）；
            // 3、校验通知中的seller_id（或者seller_email) 是否为out_trade_no这笔单据的对应的操作方（有的时候，一个商户可能有多个seller_id/seller_email）；
            // 4、验证app_id是否为该商户本身。
            // 5、其它业务逻辑情况
            Log::debug('Alipay notify', $data->all());
            //TODO::支付业务员操作
        } catch (Exception $e) {
            // $e->getMessage();
        }

        return $alipay->success();// laravel 框架中请直接 `return $alipay->success()`
    }

    /**
     * @return \Yansongda\Pay\Gateways\Wechat\MpGateway
     * 微信扫码支付
     */
    public function wechatPay($orderInfo){
        $order = [
            'out_trade_no' => $orderInfo['order_no'],
            'body' => $orderInfo['title'],
            'total_fee'      => '1',
        ];
        $this->config = config('pay.wechat');
        $result = Pay::wechat($this->config)->scan($order);
        return $result;
        /** 返回 二维码 参数
         * "return_code" => "SUCCESS"
         * "return_msg" => "OK"
         * "appid" => "wxf3cb392d86e10871"
         * "mch_id" => "1486646132"
         * "nonce_str" => "GrSOBVXGEUqdCaJ1"
         * "sign" => "8973669A00335A707E9B2A7295359C4B"
         * "result_code" => "SUCCESS"
         * "prepay_id" => "wx24182756008157f44ba694e10318210003"
         * "trade_type" => "NATIVE"
         * "code_url" => "weixin://wxpay/bizpayurl?pr=99t8zwF"
         */
    }

    /**
     * @return mixed
     * 微信回调
     */
    public function wechatNotify()
    {
        $this->config = config('pay.wechat');
        $pay = Pay::wechat($this->config);

        try{
            $data = $pay->verify(); // 是的，验签就这么简单！

            Log::debug('Wechat notify', $data->all());

            //TODO::支付业务员操作
        } catch (Exception $e) {
            // $e->getMessage();
        }

        return $pay->success()->send();// laravel 框架中请直接 `return $pay->success()`
    }

    /**
     * 查询订单
     */
    public function wechatCheck(Request $request){
        $this->config = config('pay.wechat');
        $res = Pay::wechat($this->config)->find($request->order_no);
        if($res['return_code'] == 'SUCCESS' && $res['return_msg'] == 'OK'){
            if($res['trade_state'] != 'SUCCESS'){
                $this->set('status',100);
                $this->set('msg','未支付');
            }else{
                $this->set('data',['redirect'=>url('advert/bill')]);
                $this->set('msg','支付成功');
            }
        }
        return $this->ajaxResponse();
    }

    /**
     * 支付成功：业务操作
     */
    public function setOrderPay($result,$type){
        $time = Carbon::now();
        //TODO::添加支付记录日志：
        $insert = OrderPaylog::create(['order_no'=>$result['out_trade_no'],'pay_way'=>$type,'title'=>'会员充值','pay_money'=>$result['total_amount'],'status'=>1,'result'=>json_encode($result),'recharge_type'=>'recharge','pay_time'=>$time]);
        //TODO::操作订单，会员金额添加
        Recharge::where(['order_no'=>$result['out_trade_no']])
            ->update(['pay_time'=>$time,'pay_id'=>$insert->id,'status'=>2]);
    }
}