<?php

namespace App\Http\Controllers\Web;

use App\Models\Balance;
use App\Models\BalanceChangeLog;
use App\Models\OrderPayLog;
use App\Models\Recharge;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yansongda\Pay\Pay;

class RechargeController extends Controller
{
    public $config;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public  function  index()
    {
        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            echo "<script> alert('请先登录后再试！'); </script>";
            echo "<script> parent.location.href='/login'; </script>";
        }
        return view('Home.Recharge.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validates = Validator::make($request->all(),[
            'amount'=>'required',
            'type'=>'required'
        ]);
        if(!$validates->fails())
        {
            $out_trade_no = date("YmdHis");
            $data['expire_time'] = time() + 86400;
            $data['type'] = $request->type;
            $data['order_no'] = $out_trade_no;
            $data['money'] = $request->inputAmount ? $request->inputAmount : $request->amount;
            $data['status'] = 1;
            $insert = Recharge::create($data);
            if($insert)
            {
                //调起支付
                if($data['type'] == 'alipay'){
                    $this->aliPay($data);
                }else{
                    $result = $this->wechatPay($data);
                    $no = $data['order_no'];
                    return view('Home.Recharge.pay',compact('result','no'));
                }
            }else{
                return redirect()->route('recharge.create');
            }
        }else{
            return redirect()->route('recharge.create');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * @return \Yansongda\Pay\Gateways\Alipay\WebGateway
     * 支付宝
     */
    public function aliPay($orderInfo){
        $order = [
            'out_trade_no' => $orderInfo['order_no'],
//            'total_amount' => $orderInfo['amount'],//元
            'total_amount' => 0.01,//元
            'subject' => 'test--1',
        ];
        $this->config = config('pay.alipay');
        return Pay::alipay($this->config)->web($order)->send();
    }

    /**
     * 支付宝同步回调
     */
    public function aliReturn()
    {
        $this->config = config('pay.alipay');
        $info = Pay::alipay($this->config)->verify(); // 是的，验签就这么简单！*/
        return view('Home.Index.index');
        // 订单号：$data->out_trade_no
        // 支付宝交易号：$data->trade_no
        // 订单总金额：$data->total_amount
    }

    /**
     * @return 支付宝异步回调
     */
    public function aliNotify(Request $request)
    {
        \Illuminate\Support\Facades\Log::info('--aliNotify--');
        \Illuminate\Support\Facades\Log::info(json_encode($request->all()));
        $this->config = config('pay.alipay');
        $alipay = Pay::alipay($this->config);

        try{
            $data = $alipay->verify(); // 是的，验签就这么简单！
            // 请自行对 trade_status 进行判断及其它逻辑进行判断，在支付宝的业务通知中，只有交易通知状态为 TRADE_SUCCESS 或 TRADE_FINISHED 时，支付宝才会认定为买家付款成功。
            if($data['trade_status'] == 'TRADE_SUCCESS' || $data['trade_status'] == 'TRADE_FINISHED' ){
//                $exist = Recharge::where(['order_no'=>$data['out_trade_no'],'status'=>1,'money'=>$data['total_amount']])->first();
                $exist = Recharge::where(['order_no'=>$data['out_trade_no'],'status'=>1])->first();
                if($exist){
                    $this->setOrderPay($data,'alipay');
                }
            }
            // 1、商户需要验证该通知数据中的out_trade_no是否为商户系统中创建的订单号；
            // 2、判断total_amount是否确实为该订单的实际金额（即商户订单创建时的金额）；
            // 3、校验通知中的seller_id（或者seller_email) 是否为out_trade_no这笔单据的对应的操作方（有的时候，一个商户可能有多个seller_id/seller_email）；
            // 4、验证app_id是否为该商户本身。
            // 5、其它业务逻辑情况
            Log::debug('Alipay notify', $data->all());
            //TODO::支付业务员操作
        } catch (Exception $e) {
            // $e->getMessage();
        }

        return $alipay->success();// laravel 框架中请直接 `return $alipay->success()`
    }

    /**
     * @return \Yansongda\Pay\Gateways\Wechat\MpGateway
     * 微信扫码支付
     */
    public function wechatPay($orderInfo){
        $order = [
            'out_trade_no' => $orderInfo['order_no'],
            'body' => '会员订单充值',
            'total_fee'      => '1',
        ];
        $this->config = config('pay.wechat');
        $result = Pay::wechat($this->config)->scan($order);
        return $result;
        /** 返回 二维码 参数
         * "return_code" => "SUCCESS"
         * "return_msg" => "OK"
         * "appid" => "wxf3cb392d86e10871"
         * "mch_id" => "1486646132"
         * "nonce_str" => "GrSOBVXGEUqdCaJ1"
         * "sign" => "8973669A00335A707E9B2A7295359C4B"
         * "result_code" => "SUCCESS"
         * "prepay_id" => "wx24182756008157f44ba694e10318210003"
         * "trade_type" => "NATIVE"
         * "code_url" => "weixin://wxpay/bizpayurl?pr=99t8zwF"
         */
    }

    /**
     * @return mixed
     * 微信回调
     */
    public function wechatNotify()
    {
        $this->config = config('pay.wechat');
        $pay = Pay::wechat($this->config);
        try{
            $data = $pay->verify(); // 是的，验签就这么简单！

            if($data['result_code'] == 'SUCCESS' || $data['return_code'] == 'SUCCESS' ){
//                $exist = Recharge::where(['order_no'=>$data['out_trade_no'],'status'=>1,'money'=>$data['total_amount']])->first();
                $exist = Recharge::where(['order_no'=>$data['out_trade_no'],'status'=>1])->first();
                if($exist){
                    $this->setOrderPay($data,'wechat');
                }
            }
            //TODO::支付业务员操作
        } catch (Exception $e) {
            // $e->getMessage();
        }

        return $pay->success()->send();// laravel 框架中请直接 `return $pay->success()`
    }

    /**
     * 查询订单
     */
    public function wechatCheck(Request $request){
        $this->config = config('pay.wechat');
        $res = Pay::wechat($this->config)->find($request->order_no);
        if($res['return_code'] == 'SUCCESS' && $res['return_msg'] == 'OK'){
            if($res['trade_state'] != 'SUCCESS'){
                $this->set('code',100);
                $this->set('message','未支付');
            }else{
                $this->set('data',['redirect'=>route('recharge.create')]);
                $this->set('message','支付成功');
            }
        }else{
            $this->set('code',100);
        }
        return $this->ajaxResponse();
    }

    /**
     * 支付成功:回调：业务操作
     */
    public function setOrderPay($result,$type){
        $time = Carbon::now();
        //TODO::添加支付记录日志：
        if($type == 'wechat'){
            $total = $result['total_fee'] / 100;
            $openid = $result['buyer_id'];
            $trade_no = $result['out_trade_no'];
            $status = $result['result_code'];
        }else{
            $total = $result['total_amount'];
            $openid = $result['openid'];
            $trade_no = $result['out_trade_no'];
            $status = $result['trade_status'];
        }

        $insert = OrderPaylog::create(['order_no'=>$trade_no,'pay_way'=>$type,'title'=>'会员充值','pay_money'=>$total,'result_code'=>$status,'openid'=>$openid,'result'=>json_encode($result),'recharge_type'=>'recharge','pay_time'=>$time]);
        //TODO::操作订单，会员金额添加
        Recharge::where(['order_no'=>$trade_no])
            ->update(['pay_time'=>$time,'pay_id'=>$insert->id,'status'=>2]);
        //余额变化
        $uid = 1;
        BalanceChangeLog::create(['uid'=>$uid,'money'=>$total,'type'=>1,'remark'=>'充值金额'.$total]);
        $info = User::find($uid);
        $money = $info->money + $total;
        User::where(['id'=>$uid])->update(['money'=>$money]);
    }
}
