<?php

namespace App\Http\Controllers\Web;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    public  function  index()
    {
        return view('Web.Register.index');
    }

    public  function getCode(Request $request)
    {
        $mobile = $request->input('mobile');
        $search = '/^0?1[3|4|5|6|7|8][0-9]\d{8}$/';
        if($mobile)
        {

        }elseif(!preg_match( $search, $mobile ) ){
           return json_encode(['status'=>0,'msg'=>'手机号码不正确']);
        }else{
            return json_encode(['status'=>0,'msg'=>'请输入手机号码']);
        }
    }

    public  function  register()
    {
        return view('Home.Member.register');
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     * 注册保存
     */
    public  function  registerStore(Request $request)
    {
        $validators = Validator::make($request->all(),[
            'mobile'=>'required|min:1|max:11',
            'password'=>'required|min:6|max:20',
            'captcha'=>'required'
        ]);
        if(!$validators->fails()) {
            $exist = User::where(['mobile' => $request->mobile])->first();
            if (!$exist) {
                $info = User::create(['mobile' => $request->mobile, 'password' => bcrypt($request->password)]);
                if ($info) {
                    Session::put('member.user.id', $info->id);
                    Session::put('member.user.mobile', $info->mobile);
                    Session::save();
                    return view('Home.Index.index', compact('info'));
                }
            } else {
                return redirect()->back()->with('status', '改手机号已注册');
            }
        }else{
            return redirect()->back()->with('status', '验证码不正确');
        }
    }


}
