<?php

namespace App\Http\Controllers\Web;

use App\Models\BalanceChangeLog;
use App\Models\Category;
use App\Models\Setting;
use App\Models\TrillTask;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class TrillTaskController extends Controller
{
    public  function date(Request $request)
    {

        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            $data = [
                'code' => 1,
                'msg'   => '暂无数据',
                'count' => [],
                'data'  => []
            ];
            return response()->json($data);
        }
        $model = TrillTask::where('type',$request->input('type'))->where('uid',$uid)->with('speed');
        if ($request->get('id')){
            $model = $model->where('id',$request->get('id'));
        }
        if ($request->get('trill_id')){
            $model = $model->where('trill_id',$request->get('trill_id'));;
        }

        if ($request->get('url')){
            $model = $model->where('url','like','%'.$request->get('url').'%');
        }

        if ($request->get('status')  && $request->get('status') != null){
            $model = $model->where('status',$request->get('status'));
        }
        $res = $model->orderBy('created_at','desc')->paginate($request->get('limit',30))->toArray();
        $data = [
            'code' => 0,
            'msg'   => '正在请求中...',
            'count' => $res['total'],
            'data'  => $res['data']
        ];
        return response()->json($data);
    }
    /**
     * 描述：提交任务
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public  function  postCron(Request $request)
    {
        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            $data = [
                'code' =>1,
                'msg'   => '请登录后提交',
                'count' => '',
                'data'  => ''
            ];
            return response()->json($data);
        }
        $user = User::where('id',$uid)->first();
        $speed_info = Setting::where('id',$request->input('speed'))->first();
        $data['type']  = $request->input('type');
        $data['url']  = $request->input('url') ? $request->input('url'): "";
        $data['trill_id']  = $request->input('trill_id') ? $request->input('trill_id'): "0";
        $data['speed_id']  = $request->input('speed');
        $data['require_like']  = $request->input('require_like');
        $data['content']  = $request->input('content');

        $count = $data['require_like'] *  $speed_info->value / 100;
        $data['price']  =$count;
        if($user->money < $count )
        {
            return response()->json(['code'=>0,'msg'=>'余额不足,请充值']);
        }
        $user->money  -=$count;
        $user->save();
        //TODO
        $data['uid']  =$user->id;

        $result = TrillTask::create($data);
        if($result)
        {
            $money_change['money'] = $count;
            $money_change['type'] =   $data['type'];
            $money_change['remark'] = '抖音业务:'. $data['type'].'提交' ;
            BalanceChangeLog::create($money_change);
            return response()->json(['code'=>1,'msg'=>'提交成功']);
        }
        return response()->json(['code'=>0,'msg'=>'提交失败']);
    }
    /**
     * 描述：任务修改
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  edit($id)
    {
        $info = TrillTask::find($id);
        if($info->type == 1)
        {
            $cate = Category::where('key','trill_fans')->first();
            $rout = "trill.fans";
        }elseif($info->type == 2){
            $cate = Category::where('key','trill_like')->first();
            $rout = "trill.like";
        }elseif($info->type == 3){
            $cate = Category::where('key','trill_comment')->first();
            $rout = "trill.comment";
        }elseif($info->type == 4){
            $cate = Category::where('key','trill_transmit')->first();
            $rout = "trill.transmit";
        } elseif($info->type == 5){
            $cate = Category::where('key','trill_watch')->first();
            $rout = "trill.watch";
        }
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }

        return view('Home.Trill.edit',compact('info','speeds','rout'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $trill= TrillTask::findOrFail($request->input('id'));
        $price = Setting::where('id',$trill->speed_id)->first(['value'])->value;

        $data['trill_id'] = $request->input('trill_id');
        $data['require_like'] = $request->input('require_like');
        $data['speed_id'] = $request->input('speed_id');
        $data['content'] = $request->input('content');
        $data['price']   = $data['require_like'] * $price /100;
        $rout = $request->input('route');
        if ($trill->update($data)){
            return redirect()->to(route($rout))->with(['status'=>'更新成功']);
        }
        return redirect()->to(route($rout))->withErrors('系统错误');
    }
    /**
     * 描述：单条删除
     * @param Request $request
     * @return array
     */
    public  function  destroy(Request $request)
    {
        $id = $request->input('id');
        $query = TrillTask::where('id',$id)->delete();
        if($query)
        {
            $this->set('code',1);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 0);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }
    /**
     * 描述：粉丝
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillFans()
    {
        $uid = Session::get('member.user.id');
        $user =[];
        if($uid){
            $user = User::where('id',$uid)->first();
        }
        $cate = Category::where('key','trill_fans')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }

        return view('Home.Trill.trillFans',compact('speeds','user'));
    }
    /**
     * 描述：点赞
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillLike()
    {
        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','trill_like')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Trill.trillLike',compact('speeds','user'));
    }
    /**
     * 描述：评论
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillComment()
    {
        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','trill_comment')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Trill.trillComment',compact('speeds','user'));
    }
    /**
     * 描述：转发
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillTransmit()
    {
        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','trill_transmit')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Trill.trillTransmit',compact('speeds','user'));
    }
    /**
     * 描述：观看量
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  trillWatch()
    {
        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','trill_watch')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Trill.trillWatch',compact('speeds','user'));
    }




















}
