<?php

namespace App\Http\Controllers\Web;

use App\Models\BalanceChangeLog;
use App\Models\Category;
use App\Models\Setting;
use App\Models\User;
use App\Models\ViewTask;
use App\Models\WeChatTask;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class ViewTaskController extends Controller
{
    public  function readBrushDate(Request $request)
    {

        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            $data = [
                'code' => 1,
                'msg'   => '暂无数据',
                'count' => [],
                'data'  => []
            ];
            return response()->json($data);
        }
        $model = ViewTask::where('type',$request->input('type'))->where('uid',$uid)->with('speed');
        if ($request->get('id')){
            $model = $model->where('id',$request->get('id'));
        }
        if ($request->get('title')){
            $model = $model->where('title','like','%'.$request->get('title').'%');
        }

        if ($request->get('url')){
            $model = $model->where('url','like','%'.$request->get('url').'%');
        }

        if ($request->get('status')  && $request->get('status') != null){
            $model = $model->where('status',$request->get('status'));
        }
        $res = $model->orderBy('created_at','desc')->paginate($request->get('limit',30))->toArray();
        $data = [
            'code' => 0,
            'msg'   => '正在请求中...',
            'count' => $res['total'],
            'data'  => $res['data']
        ];
        return response()->json($data);
    }

    /**
     * 描述：提交任务
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public  function  postCron(Request $request)
    {
        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            $data = [
                'code' =>1,
                'msg'   => '请登录后提交',
                'count' => '',
                'data'  => ''
            ];
            return response()->json($data);
        }
        $user = User::where('id',$uid)->first();
        $speed_info = Setting::where('id',$request->input('speed'))->first();
        $data['type']  = $request->input('type');
        $data['url']  = $request->input('url');
        $data['speed_id']  = $request->input('speed');
        $data['source']  = $request->input('source');
        $data['require_views']  = $request->input('require_views');

        $count = $data['require_views'] *  $speed_info->value / 1000;
        $data['price']  =$count;
         if($user->money < $count )
         {
             return response()->json(['code'=>0,'msg'=>'余额不足,请充值']);
         }
         $user->money  -=$count;
         $user->save();
        //TODO
         $data['uid']  =$user->id;
         $result = ViewTask::create($data);
         if($result)
         {
             $money_change['money'] = $count;
             $money_change['type'] =   $data['type'];
             $money_change['remark'] = '提交刷阅读量任务:'. $data['type'] ;
             BalanceChangeLog::create($money_change);
             return response()->json(['code'=>1,'msg'=>'提交成功']);
         }
        return response()->json(['code'=>0,'msg'=>'提交失败']);
    }

    /**
     * 描述：任务修改
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  edit($id)
    {
        $info = ViewTask::find($id);
        if($info->type == 1)
        {
            $cate = Category::where('key','read_brush_one')->first();
            $rout = "view.read.brush.one";
        }elseif($info->type == 2){
            $cate = Category::where('key','read_brush_two')->first();
            $rout = "view.read.brush.two";
        }elseif($info->type == 3){
            $cate = Category::where('key','read_brush_three')->first();
            $rout = "view.read.brush.three";
        } elseif($info->type == 5){
            $cate = Category::where('key','read_reality_one')->first();
            $rout = "view.read.reality.one";
        }
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.View.edit',compact('info','speeds','rout'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data['title'] = $request->input('title');
        $data['url'] = $request->input('url');
        $data['speed_id'] = $request->input('speed_id');
        $view = ViewTask::findOrFail($request->input('id'));
        $rout = $request->input('route');
        if ($view->update($data)){
            return redirect()->to(route($rout))->with(['status'=>'更新成功']);
        }
        return redirect()->to(route($rout))->withErrors('系统错误');
    }



    /**
     * 描述：单条删除
     * @param Request $request
     * @return array
     */
    public  function  destroy(Request $request)
    {
        $id = $request->input('id');
        $query = ViewTask::where('id',$id)->delete();
        if($query)
        {
            $this->set('code',0);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 1);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }

    /**
     * 描述：机刷无误1
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  readBrushOne()
    {
        $uid = Session::get('member.user.id');
        $user =[];
        if($uid){
          $user = User::where('id',$uid)->first();
        }
        $cate = Category::where('key','read_brush_one')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.View.readBrushOne',compact('speeds','user'));
    }
    /**
     * 描述：机刷无误2
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  readBrushTwo()
    {

        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','read_brush_two')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.View.readBrushTwo',compact('speeds','user'));
    }
    /**
     * 描述：机刷无误3
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  readBrushThree()
    {
        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','read_brush_three')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.View.readBrushThree',compact('speeds','user'));
    }
    /**
     * 描述：真人有误1
     * @param  $speeds  array    速度类型
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  readRealityOne()
    {
        $uid = Session::get('member.user.id');
        $user ='';
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','read_reality_one')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.View.readRealityOne',compact('speeds','user'));
    }


}
