<?php

namespace App\Http\Controllers\Web;

use App\Models\BalanceChangeLog;
use App\Models\Category;
use App\Models\Setting;
use App\Models\User;
use App\Models\ViewTask;
use App\Models\WeChatTask;
use App\Traits\UploadImg;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class WechatTaskController extends Controller
{
    public  function  zombies()
    {
        $uid = Session::get('member.user.id');
        $user =[];
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','zombies_fans')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Wechat.zombies',compact('speeds','user'));
    }

    /**
     * 扫码加僵尸粉
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function wechatScanfans()
    {
        $uid = Session::get('member.user.id');
        $user =[];
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','wechat_scan_fans')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Wechat.wechatScanfans',compact('speeds','user'));
    }


    /**
     * 描述：微信真人活粉(需要授权)
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function wechatRealityFans()
    {
        $uid = Session::get('member.user.id');
        $user =[];
        if($uid){
            $user = User::where('id',$uid)->first();

        }
        $cate = Category::where('key','reality_fans')->first();
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Wechat.wechatReality',compact('speeds','user'));
    }

    /**
     * 描述：数据请求
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public  function zombiesDate(Request $request)
    {
        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            $data = [
                'code' => 1,
                'msg'   => '暂无数据',
                'count' => [],
                'data'  => []
            ];
            return response()->json($data);
        }
        $model = WeChatTask::where('type',$request->input('type'))->where('uid',$uid)->with('speed');
        if ($request->get('id')){
            $model = $model->where('id',$request->get('id'));
        }
        if ($request->get('wechat_name')){
            $model = $model->where('wechat_name','like','%'.$request->get('wechat_name').'%');
        }

        if ($request->get('wechat_account')){
            $model = $model->where('wechat_account','like','%'.$request->get('wechat_account').'%');
        }

        if ($request->get('status')  && $request->get('status') != null){
            $model = $model->where('status',$request->get('status'));
        }
        $res = $model->orderBy('created_at','desc')->paginate($request->get('limit',30))->toArray();

        $data = [
            'code' => 0,
            'msg'   => '正在请求中...',
            'count' => $res['total'],
            'data'  => $res['data']
        ];
        return response()->json($data);
    }
    /**
     * 描述：提交任务
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public  function  postCron(Request $request)
    {
        $uid = Session::get('member.user.id');
        if(!$uid)
        {
            $data = [
                'code' =>1,
                'msg'   => '请登录后提交',
                'count' => '',
                'data'  => ''
            ];
            return response()->json($data);
        }
        $user = User::where('id',$uid)->first();
        $speed_info = Setting::where('id',$request->input('speed'))->first();
        $data['type']  = $request->input('type');
        if( $request->input('wechat_name')){
            $data['wechat_name']  = $request->input('wechat_name');
            $data['wechat_account']  = $request->input('wechat_account');
        }

        if( $request->input('title')){
            $data['title']  = $request->input('title');
            $data['reply']  = $request->input('reply');
        }
        if( $request->input('image')){
            $data['image']  = $request->input('image');
        }

        $data['speed_id']  = $request->input('speed');
        $data['require_collect']  = $request->input('require_views');

        $count = $data['require_collect'] *  $speed_info->value / 1000;
        $data['price']  =$count;
        if($user->money < $count )
        {
            return response()->json(['code'=>0,'msg'=>'余额不足,请充值']);
        }
        $user->money  -=$count;
        $user->save();
        //TODO
        $data['uid']  =$user->id;
        $result = WeChatTask::create($data);
        if($result)
        {
            $money_change['money'] = $count;
            $money_change['type'] = 2;
            if($data['type'] == 5){
                $money_change['remark'] = '微信官方投票任务任务:'. $data['type'] ;
            }else{
                $money_change['remark'] = '提交公众号增粉任务:'. $data['type'] ;
            }

            BalanceChangeLog::create($money_change);
            return response()->json(['code'=>1,'msg'=>'提交成功']);
        }
        return response()->json(['code'=>0,'msg'=>'提交失败']);
    }

    /**
     * 描述：任务修改
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  edit($id)
    {
        $info = WeChatTask::find($id);
        if($info->type == 1)
        {
            $cate = Category::where('key','zombies_fans')->first();
            $rout = "wechat.zombies";
        }else{
            $cate = Category::where('key','zombies_fans')->first();
            $rout = "vwechat.zombies";
        }
        $ids= explode('，',$cate->speed_ids);
        foreach ($ids as $key => $val)
        {
            $speeds[] = Setting::where('id',$val)->first(['id','name','value','remark']);
        }
        return view('Home.Wechat.edit',compact('info','speeds','rout'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        if($request->input('wechat_account'))
        {
            $data['wechat_account'] = $request->input('wechat_account');
            $data['wechat_name'] = $request->input('wechat_name');
        }else{
            $data['title']  = $request->input('title');
            $data['reply']  = $request->input('reply');
        }
        $data['speed_id'] = $request->input('speed_id');
        $view = WeChatTask::findOrFail($request->input('id'));
        $rout = $request->input('route');
        if ($view->update($data)){
            return redirect()->to(route($rout))->with(['status'=>'更新成功']);
        }
        return redirect()->to(route($rout))->withErrors('系统错误');
    }
    /**
     * 描述：单条删除
     * @param Request $request
     * @return array
     */
    public  function  destroy(Request $request)
    {
        $id = $request->input('id');
        $query = ViewTask::where('id',$id)->delete();
        if($query)
        {
            $this->set('code',0);
            $this->set('info','删除成功');
        }else
        {
            $this->set('code', 1);
            $this->set('info', '删除失败');
        }
        return $this->ajaxResponse();
    }

    /**
     * 描述：图片上传
     * @param Request $request
     * @return string
     */
   public  function  upload(Request $request)
   {
       if($request->hasFile('file') && $request->file('file')->isValid())
       {
           $image = new  UploadImg();
           $path=  $image->postUploadImg($request);

           if( is_array($path) && $path['error'] === 'You may only upload png, jpg or gif.')
           {
               return  json_encode(['code'=>1,'info'=>'图片格式为：png 或 jpg 或 gif']);
           }elseif (substr($path,0,4) == 'error')
           {
               return  json_encode(['code'=>1,'info'=>'未知错误']);
           }
           return json_encode(['code'=>0,'info'=>$path]);
       }
       else
       {
           return  json_encode(['code'=>1,'info'=>'null']);
       }
   }


    /**
     * 描述：线下共享纸巾真人粉
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
   public  function  onlineShareRealityFans()
   {

       return view('Home.Wechat.onlineShareRealityFans');
   }
    /**
     * 描述：线下共享WIFI真人粉
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function  onlineShareWIFIFans()
    {

        return view('Home.Wechat.onlineShareWIFIFans');
    }
    /**
     * 描述：真人活粉（无需授权）
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public  function shareRealityFans()
    {
        return view('Home.Wechat.shareRealityFans');
    }




}
