<?php

namespace App\Http\Middleware;

use Closure;
use Encone\Logs\Models\Logs;
use Illuminate\Support\Facades\Session;

class ActionLogs
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(Session::get('username'))
        {
            $username = Session::get('username');
            $id = Session::get('id');
        }else{
            $username = $request->username;
            $id = 0;
        }
        $description = $username.' ';
        Logs::createLog(['admin_user_id'=>$id,'method'=>$request->method(),'route'=>$request->path(),'ip'=>$request->getClientIp(),'description'=>$description]);
        return $next($request);
    }
}
