<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasRoles;

class AdminUser extends Authenticatable
{
    use HasRoles;

    protected $guard_name = 'web';

    protected $table = 'admin_users';

    public $fillable = [
        'username','password','name','avatar','remember_token','last_login_ip','last_login_time','created_at','updated_at','mobile','role','sex','description','email','department'
    ];

    public function getRole()
    {
        return $this->hasOne(Role::class,'name','role');
    }
}
