<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model
{
    use SoftDeletes;

    protected $table = 'permissions';

    protected $dates = ['delete_at'];

    protected $fillable = [
        'id','name','guard_name','pid','describe','route','type'
    ];

    public function subPermissions()
    {
        return $this->hasMany(Permission::class,'pid','id');
    }

    public function parentsPermission()
    {
        return $this->belongsTo(Permission::class,'pid','id');
    }

}
