<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tag extends Model
{
    //
    use SoftDeletes;

    protected $dates=['deleted_at'];

    protected $fillable=['name','type','sort','pid'];

    public function child(){

        return $this->hasMany(Tag::class,'pid','id');
    }

    public function parent(){

        return $this->belongsTo(Tag::class,'pid','id');
    }
}
