<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ViewTask extends Model
{
    protected  $table   = 'views_tasks';
    protected  $guarded =[];

    /**
     * 描述：获取发布人信息
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public  function  userInfo()
    {
        return $this->hasOne(User::class,'id','uid');
    }

    /**
     * 描述：获取接单人信息
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public  function  acceptInfo()
    {
        return $this->hasOne(User::class,'id','accept_uid');
    }
    /**
     * 描述：获取任务信息
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public  function  crontab()
    {
        return $this->hasOne(Crontab::class,'task_id','id');
    }
    /**
     * 描述：获取速度分类信息
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public  function  speed()
    {
        return $this->hasOne(Setting::class,'id','speed_id');
    }

}
