<?php

namespace App\Providers;

use App\Models\AdminUser;
use App\Models\Permission;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;
use Spatie\Permission\Contracts\Role;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        view()->composer('*',function($view){
            /*$path = Request::path();
            $route = str_replace('admin/','',$path);
            $naviPath = [];
            if($route != 'index') {
                $route = str_replace('/', '.', $route);
                $permission = Permission::where(['name' => $route])->with('parentsPermission')->first();
                if($permission->parentsPermission) {
                    $naviPath[] = ['name' => $permission->parentsPermission->describe, 'route' => ''];
                }
                $naviPath[] = ['name' => $permission->describe, 'route' => 'admin/' . $route];
            }*/
            $user = AdminUser::with('getRole')->find(Session::get('admin.id'));
            $info = ['name'=>$user['username'],'role'=>$user['getRole']['describe']];

            $view->with('shareUserInfo',$info);
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
