<?php
/**
 * Created by Hacking.
 * User: encone
 * Date: 2018/7/18
 * Time: 9:23
 */

namespace App\Traits;


class UploadImg
{
    /*
      * 图片文件夹创建
      */
    public function mkDirs($dir){
        if(!is_dir($dir)){
            if(!$this->mkDirs(dirname($dir))){
                return false;
            }
            if(!mkdir($dir,0777)){
                return false;
            }
        }
        return true;
    }

    /**
     * @param $base64
     * base64解析为图片
     */
    public function base64Decode($string)
    {
        //判断图片类型
        $filetype = substr($string,0,strpos($string,';'));
        $type = substr($filetype,strpos($filetype,'/')+1);
        //判断图片 base64
        $data = substr($string,strpos($string,';')+8);
        if ($data && $data) {
            $img = base64_decode($data);
            //生产文件名称
            $destinationPath = public_path() .'/upload/'. date('Y', time()) . '/' . date('Ym', time()) . '/' . date('Ymd', time()) . '/';
//            $destinationPath = 'E:/upload/images/' . date('Y', time()) . '/' . date('Ym', time()) . '/' . date('Ymd', time()) . '/';
            $this->mkDirs($destinationPath);
            //name:/2017/201701/20170101/000001.png
            $fileName = time() . rand(1000, 9999) . '.'.$type ;
            $bytes = file_put_contents($destinationPath . $fileName, $img);//返回的是字节数
            // $url = substr($destinationPath . $fileName, strpos($destinationPath . $fileName, 'upload') + 6);

            if($bytes)
            {
                $url = str_replace(public_path(),'',$destinationPath . $fileName);
//                $url = str_replace('E:/upload','',$destinationPath . $fileName);
                return $url;
            }
            else
            {
                return false;
            }
        }
    }

    /**
     * @param $request
     * @return array|string
     * 图片上传
     */
    public function postUploadImg($request)
    {
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $data = $request->all();
            $rules = [
                'file'    => 'max:5120',
            ];
            $messages = [
                'file.max'    => '文件过大,文件大小不得超出5MB',
            ];
            $validator = Validator($data, $rules, $messages);
            if (!$validator->fails()) {
                $allowed_extensions = ["png", "jpg", "gif","jpeg","PNG","JPG","GIF"];
                if ($file->getClientOriginalExtension() && !in_array($file->getClientOriginalExtension(), $allowed_extensions)) {
                    return ['error' => 'You may only upload png, jpg or gif.'];
                }
                // $destinationPath = '/home/www/upload/images/'.date('Y',time()).'/'.date('Ym',time()).'/'.date('Ymd',time()).'/';
                $destinationPath = public_path() .'/upload/image/'.date('Y',time()).'/'.date('m',time()).'/'.date('d',time()).'/';
                $extension = $file->getClientOriginalExtension();
                $this->mkDirs($destinationPath);
                //name:/2017/201701/20170101/000001.png
                $fileName = time() . rand(1000, 9999) . '.' . $extension;
                $file->move($destinationPath, $fileName);
                //  $res = 'http://web.com/'.substr($destinationPath . $fileName,strpos($destinationPath . $fileName,'upload'));
                $res = substr($destinationPath . $fileName,strpos($destinationPath . $fileName,'upload'));
            } else {
                $res = 'error|'.'失败';
            }
        }
        else
        {
            $res = 'error|失败原因为：非法传参';
        }
        return $res;
    }
}