<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTagsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tags', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name',50)->comment('标签名称');
            $table->integer('pid')->length(10)->comment('父级id');
            $table->integer('sort')->length(10)->unsigned()->default(0)->comment('排序');
            $table->tinyInteger('type')->length(2)->unsigned()->default(0)->comment('标签类型:1=>顾问标签,2=>评价勾选标签,3=>投诉勾选标签');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tags');
    }
}
