<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('admin_user_id')->length(10)->unsigned()->comment('管理员id');
            $table->string('route',255)->default('')->comment('操作路由');
            $table->string('method',20)->default('')->comment('操作方法:GET/PUT/POST/DELETE');
            $table->text('description')->comment('操作描述');
            $table->string('ip',20)->default('')->comment('ip地址');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logs');
    }
}
