<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdminUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admin_users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('username',255)->comment('用户名');
            $table->string('password',255)->comment('密码');
            $table->string('name',50)->comment('名称');
            $table->string('avatar',255)->nullable()->comment('头像');
            $table->string('remember_token')->nullable();
            $table->string('remember_token',255)->nullable()->change();
            $table->string('last_login_ip',255)->nullable()->comment('最后登录ip');
            $table->string('last_login_time',255)->nullable()->comment('最后登录时间');
            $table->timestamps();
            $table->string('mobile',11)->default('')->comment('电话号码')->nullable();
            $table->string('sex',20)->comment('性别')->default('male');
            $table->string('description',255)->comment('描述')->nullable();
            $table->string('role',50)->comment('角色')->nullable();
            $table->string('email',50)->comment('邮箱')->nullable();
            $table->tinyInteger('status')->length(1)->comment('禁用状态')->default(1)->nullable();
            $table->softDeletes();
            $table->string('department',50)->nullable()->comment('部门名称');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admin_users');
    }
}
