<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddVotesToPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('permissions', function (Blueprint $table) {
            //
            $table->integer('pid')->length(10)->unsigned()->comment('parent id');
            $table->string('describe',255)->nullable()->comment('description');
            $table->string('route',50)->nullable()->comment('route');
            $table->string('type',20)->nullable()->comment('type');
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permissions', function (Blueprint $table) {
            //
            $table->dropColumn('pid');
            $table->dropColumn('describe');
            $table->dropColumn('route');
            $table->dropColumn('type');
        });
    }
}
