@extends('Layouts.iframe')
@section('content')
    <div class="page-container">
        <form action="" method="post" class="form form-horizontal" id="form-category-add">
            <div class="row cl" >
                <label class="form-label col-xs-4 col-sm-2" style="text-align: left;">
                    <span class="c-red">*</span>
                    栏目名称：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="name" id="name">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2" style="text-align: left;">
                    <span class="c-red">*</span>
                    控制器路径：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="url" id="url">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2" style="text-align: left;">
                    <span class="c-red">*</span>
                    速度类型：</label>
                <div style="float: left">
                    @if($settings)
                        @foreach($settings as $key => $item)
                            @if($key % 2 ==0 && $key != 0)
                                <br/>
                            @endif
                            <div class="check-box" style="width: 280px">
                                <input  name="speed_ids[]" type="checkbox" id="checkbox-{{$key+1}}" value="{{$item->id}}">
                                <label for="checkbox-{{$key+1}}">{{$item->name}}/{{$item->value}}元（千）</label>
                            </div>
                        @endforeach
                    @endif

                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3" style="text-align: left;">
                    <span class="c-red">*</span>接单状态：</label>
                <div class="formControls col-xs-8 col-sm-9 skin-minimal">
                    <div class="radio-box">
                        <input name="status" type="radio" id="sex-1" checked value="1">
                        <label for="sex-1">是</label>
                    </div>
                    <div class="radio-box">
                        <input type="radio" id="sex-2" name="status" value="0">
                        <label for="sex-2">否</label>
                    </div>
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2" style="text-align: left;">上级分类：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <select name="pid" id="" class="select ">
                        <option value="">请选择分类</option>
                        @if($groups)
                            @foreach($groups as $item)
                                <option value="{{$item->id}}">@if($item->parent) {{$item->parent['name'] .' >'}} @endif  {{ $item->name }}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
            </div>
            <div class="row cl">
                <div class="col-9 col-offset-2">
                    <button onClick="category_save_submit();" class="btn btn-primary radius" type="submit"><i class="Hui-iconfont">&#xe632;</i> 提交</button>
                </div>
            </div>
        </form>
    </div>
@section('js')
    <!--请在下方写此页面业务相关的脚本-->
    <script type="text/javascript" src="/js/lib/jquery.validation/1.14.0/jquery.validate.js"></script>
    <script type="text/javascript" src="/js/lib/jquery.validation/1.14.0/validate-methods.js"></script>
    <script type="text/javascript" src="/js/lib/jquery.validation/1.14.0/messages_zh.js"></script>
    <script type="text/javascript">
        function category_save_submit(){
            $("#form-category-add").validate({
                rules:{
                    name:{
                        required:true,
                    }
                },
                onkeyup:false,
                focusCleanup:true,
                success:"valid",
                submitHandler:function(form) {
                    $(form).ajaxSubmit({
                        type: 'post',
                        url: "{{ url('admin/category') }}" ,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(data){
                            if(data.code == 0) {
                                layer.msg(data.message, {icon: 1, time: 2000},function () {
                                    window.parent.location.reload();
                                });

                                setTimeout(function(){
                                    window.parent.location.reload();
                                },2000);
                            }else{
                                layer.msg(data.message, {icon: 2, time: 2000});
                            }

                        },
                        error: function(XmlHttpRequest, textStatus, errorThrown){
                            layer.msg('error!',{icon:2,time:2000});
                        }
                    });
                    /* var index = parent.layer.getFrameIndex(window.name);
                     //parent.$('.btn-refresh').click();
                     parent.layer.close(index);*/
                }
            });
        }
    </script>
@endsection