@extends('Layouts.iframe')
@section('content')
    <div class="page-container">
        <form action="" method="post" class="form form-horizontal" id="form-permission-add">
            <div id="tab-category" class="HuiTab">
                <div class="tabBar cl">
                    <span>权限设置</span>
                </div>
                <div class="tabCon">
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">
                            <span class="c-red">*</span>
                            上级栏目：</label>
                        <div class="formControls col-xs-8 col-sm-9">
						<span class="select-box">
						<select class="select" id="sel_Sub" name="sel_Sub" >
                            <option value="0">首页</option>
                            @if($page)
                                @foreach($page as $item)
                                    <option value="{{ $item->id }}">{{ $item->describe }}</option>
                                    @if($item->subPermissions)
                                        @foreach($item->subPermissions as $value)
                                            <option value="{{ $value->id }}">&nbsp;&nbsp;├ {{ $value->describe  }}</option>
                                        @endforeach
                                    @endif
                                @endforeach
                            @endif
                        </select>
						</span>
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">
                            <span class="c-red">*</span>
                            名称：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="" placeholder="请输入拼音/英文" id="" name="name">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">别名：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="" placeholder="" id="" name="describe">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">路由：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="" placeholder="" id="" name="route">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">类型：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="radio" name="type" id="" value="group" onclick="showRequest(this)" checked>默认添加组
                            <input type="radio" name="type" id="" value="single" onclick="showRequest(this)">添加单个
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl request_" style="display:none;">
                        <label class="form-label col-xs-4 col-sm-3">请求方式：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="" placeholder="" id="" name="requestType">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row cl">
                <div class="col-9 col-offset-3">
                    <input class="btn btn-primary radius" type="submit" value="&nbsp;&nbsp;提交&nbsp;&nbsp;">
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        var flag = true;
        $(function(){
            $('.skin-minimal input').iCheck({
                checkboxClass: 'icheckbox-blue',
                radioClass: 'iradio-blue',
                increaseArea: '20%'
            });

            $("#tab-category").Huitab({
                index:0
            });
            $("#form-permission-add").validate({
                rules:{
                    sel_Sub:{
                        required:true,
                    },
                    name:{
                        required:true,
                    },
                    describe:{
                        required:true
                    },
                    type:{
                        required:true
                    }
                },
                onkeyup:false,
                focusCleanup:true,
                success:"valid",
                submitHandler:function(form){
                    //不能包含“/”
                    var strs = $('input[name="route"]').val();
                    if ($('input[name="type"]:checked').val() == 'group' && (strs.indexOf("/") >= 0))
                    {
                        layer.msg('添加组不能添加“/”', {icon: 2, time: 1000});
                    }
                    /*单个添加：请求方式: 添加 请求类型 */
                    var str = $.trim($('input[name="requestType"]').val());
                    if ($('input[name="type"]:checked').val() == 'single' && (str == '' || str == 'null' || str == null || str == 'undefined' || str == undefined))
                    {
                        layer.msg('请求方式不能为空', {icon: 2, time: 1000});
                    }
                    //*数据提交*//
                    if(flag){
                        flag = false;
                        $(form).ajaxSubmit({
                                type: 'post',
                                url: "{{ url('admin/permission') }}",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                success: function (res) {
                                    layer.msg(res.message, {icon: 1, time: 1000},function () {
                                        parent.location.reload();
                                    });
                                    // setTimeout(function(){
                                    //     var index = parent.layer.getFrameIndex(window.name);
                                    //     parent.$('.btn-refresh').click();
                                    //     parent.layer.close(index);
                                    // },2000);
                                }
                            }
                        );
                    }

                }
            });
        });
        /** */
        function showRequest(type){
            $(type).val() == 'single' ? $('.request_').show() : $('.request_').hide()
        }
    </script>
@endsection