@extends('Layouts.iframe')
@section('content')
    <div class="page-container">
        <form action="" method="post" class="form form-horizontal" id="form-permission-add">
            <div id="tab-category" class="HuiTab">
                <div class="tabBar cl">
                    <span>权限设置</span>
                </div>
                <div class="tabCon">
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">
                            <span class="c-red">*</span>
                            上级栏目：</label>
                        <div class="formControls col-xs-8 col-sm-9">
						<span class="select-box">
						<select class="select" id="sel_Sub" name="sel_Sub">
                            @if($show['route']=='')
                                <option value="0" selected>首页</option>
                            @else
                                <option value="{{ $show['parentsPermission']['id'] }}" selected>{{ $show['parentsPermission']['describe'] }}</option>
                            @endif

                            <option value="0">首页</option>
                            @if($page)
                                @foreach($page as $item)
                                    <option value="{{ $item->id }}">{{ $item->describe }}</option>
                                    @if($item->subPermissions)
                                        @foreach($item->subPermissions as $value)
                                            <option value="{{ $value->id }}">&nbsp;&nbsp;├ {{$value->describe}}</option>
                                        @endforeach
                                    @endif
                                @endforeach
                            @endif
                        </select>
						</span>
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">
                            <span class="c-red">*</span>
                            名称：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="{{$show->name}}" placeholder="请输入拼音/英文" id="" name="name">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">别名：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="{{$show->describe}}" placeholder="" id="" name="describe">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl">
                        <label class="form-label col-xs-4 col-sm-3">路由：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="{{$show->route}}" placeholder="" id="" name="route">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                    <div class="row cl request_">
                        <label class="form-label col-xs-4 col-sm-3">请求方式：</label>
                        <div class="formControls col-xs-8 col-sm-9">
                            <input type="text" class="input-text" value="{{$show->type}}" placeholder="" id="" name="requestType">
                        </div>
                        <div class="col-3">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row cl">
                <div class="col-9 col-offset-3">
                    <input class="btn btn-primary radius" type="submit" value="&nbsp;&nbsp;提交&nbsp;&nbsp;">
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(function(){
            $('.skin-minimal input').iCheck({
                checkboxClass: 'icheckbox-blue',
                radioClass: 'iradio-blue',
                increaseArea: '20%'
            });

            $("#tab-category").Huitab({
                index:0
            });
            $("#form-permission-add").validate({
                rules:{
                    sel_Sub:{
                        required:true,
                    },
                    name:{
                        required:true,
                    },
                    describe:{
                        required:true
                    },
                    type:{
                        required:true
                    }
                },
                onkeyup:false,
                focusCleanup:true,
                success:"valid",
                submitHandler:function(form){
                    //*数据提交*//
                    $(form).ajaxSubmit({
                                type: 'post',
                                url: "/admin/permission/{{$show->id}}",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data:{'_method':'PUT'},
                                success: function (res) {
                                    layer.msg(res.message, {icon: 1, time: 1000});
                                    setTimeout(function(){
                                        window.parent.location.reload();
                                        /*var index = parent.layer.getFrameIndex(window.name);
                                         parent.$('.btn-refresh').click();
                                         parent.layer.close(index);*/
                                    },2000);
                                }
                            }
                    );
                }
            });
        });
        /** */
        function showRequest(type){
            $(type).val() == 'single' ? $('.request_').show() : $('.request_').hide()
        }
    </script>
@endsection