@extends('Layouts.iframe')
@section('content')
    <article class="page-container">
        <form action="" method="post" class="form form-horizontal" id="form-admin-role-add">
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>角色名称：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="" placeholder="" id="roleName" name="roleName">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">备注：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="" placeholder="" id="" name="describe">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">网站角色：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    @if($permission)
                        @foreach($permission as $item)
                            <dl class="permission-list">
                                <dt>
                                    <label class="skin-minimal2">
                                        <input type="checkbox" value="{{ $item->name }}" name="permission[]" id="user-Character-{{ $item->id }}">
                                        {{ $item->describe }}</label>
                                </dt>
                                <dd>
                                    @if($item->subPermissions)
                                        @foreach($item->subPermissions as $value)
                                            <dl class="cl permission-list2">
                                <dt>
                                    <label class="skin-minimal2">
                                        <input type="checkbox" value="{{$value->name}}" name="permission[]" id="user-Character-{{ $item->id }}-0">
                                        {{ $value->describe }}</label>
                                </dt>
                                <dd>
                                    <label class="skin-minimal2">
                                        @foreach($value->subPermissions as $sub)
                                            <input type="checkbox" value="{{$sub->name}}" name="permission[]" id="user-Character-{{ $item->id }}-0-0">
                                            {{ substr($sub->describe,strpos($sub->describe,'-')+1) }}</label>
                                    @endforeach
                                </dd>
                            </dl>
                            @endforeach
                            @endif
                            </dd>
                            </dl>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="row cl">
                <div class="col-xs-8 col-sm-9 col-xs-offset-4 col-sm-offset-3">
                    <button type="submit" class="btn btn-success radius" id="admin-role-save" ><i class="icon-ok"></i> 确定</button>
                </div>
            </div>
        </form>
    </article>

@endsection

@section('js')
    <script type="text/javascript">
        var flag = true;
        $(function () {
            $(".permission-list dt input:checkbox").click(function () {
                $(this).closest("dl").find("dd input:checkbox").prop("checked", $(this).prop("checked"));
            });
            $(".permission-list2 dd input:checkbox").click(function () {
                var l = $(this).parent().parent().find("input:checked").length;
                var l2 = $(this).parents(".permission-list").find(".permission-list2 dd").find("input:checked").length;
                if ($(this).prop("checked")) {
                    $(this).closest("dl").find("dt input:checkbox").prop("checked", true);
                    $(this).parents(".permission-list").find("dt").first().find("input:checkbox").prop("checked", true);
                }
                else {
                    if (l == 0) {
                        $(this).closest("dl").find("dt input:checkbox").prop("checked", false);
                    }
                    if (l2 == 0) {
                        $(this).parents(".permission-list").find("dt").first().find("input:checkbox").prop("checked", false);
                    }
                }
            });


            $("#form-admin-role-add").validate({
                rules: {
                    roleName: {
                        required: true,
                    },
                },
                onkeyup: false,
                focusCleanup: true,
                success: "valid",
                submitHandler: function (form) {
                    if(flag){
                        flag = false;
                        $(form).ajaxSubmit({
                            url:"{{ url('admin/role') }}",
                            type:'post',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function(data){
                                console.log(data);
                                if(data.code == 0) {
                                    layer.msg(data.message, {icon: 1, time: 2000},function () {
                                        parent.location.reload();
                                    });
                                }else{
                                    layer.msg(data.message, {icon: 2, time: 2000});
                                }
                            },
                            error: function(XmlHttpRequest, textStatus, errorThrown){
                                layer.msg('error!',{icon:1,time:2000});
                            }
                        });
                    }

                    /* var index = parent.layer.getFrameIndex(window.name);
                     parent.layer.close(index);*/
                }
            });
        });
    </script>
@endsection
