@extends('Layouts.iframe')
@section('content')
    <nav class="breadcrumb">
        <i class="Hui-iconfont">&#xe67f;</i> 首页
        <span class="c-gray en">&gt;</span> 管理员管理
        <span class="c-gray en">&gt;</span> 角色管理
        <span class="c-gray en">&gt;</span>

        <a class="btn btn-success radius r" style="line-height:1.6em;margin-top:3px" href="javascript:location.replace(location.href);" title="刷新" ><i class="Hui-iconfont">&#xe68f;</i></a>
    </nav>
    <div class="page-container">
        <div class="cl pd-5 bg-1 bk-gray">
            <span class="l">
               {{-- <a href="javascript:;" onclick="datadel()" class="btn btn-danger radius"><i class="Hui-iconfont">&#xe6e2;</i> 批量删除</a> --}}
                @can('role.create')
                <a class="btn btn-primary radius" href="javascript:;" onclick="admin_role_add('添加角色','{{ url('admin/role/create') }}','800')"><i class="Hui-iconfont">&#xe600;</i> 添加角色</a> </span>
            @endcan
            <span class="r">共有数据：<strong>{{ $page->total() }}</strong> 条</span>
        </div>
        <table class="table table-border table-bordered table-hover table-bg">
            <thead>
            <tr>
                <th scope="col" colspan="6">角色管理</th>
            </tr>
            <tr class="text-c">
                {{--<th width="25"><input type="checkbox" value="" name=""></th>--}}
                <th width="40">编号</th>
                <th width="300">角色名</th>
                <th >用户列表</th>
                @if(auth()->user()->can('role.edit') or auth()->user()->can('role.destroy'))
                    <th width="150">操作</th>
                @endif
            </tr>
            </thead>
            @if($page)
                <tbody>
                @foreach($page as $k=>$item)
                    <tr class="text-c">
                        {{--<td><input type="checkbox" value="" name=""></td>--}}
                        <td>{{$k+1}}</td>
                        <td>{{$item->describe}}</td>
                        <td>{{ $item->name }}</td>
                        @if(auth()->user()->can('role.edit') or auth()->user()->can('role.destroy'))
                            <td class="f-14">
                                @if($item->id > 1)
                                    @can('role.edit')
                                    <a title="编辑" href="javascript:;" onclick="admin_role_edit('角色编辑','{{ url('admin/role/'.$item->id.'/edit')  }}','{{$item->id}}')"  class="label label-primary  radius">编辑</a>
                                    @endcan
                                    {{--@can('role.destroy')--}}
                                    {{--<a title="删除" href="javascript:;" onclick="admin_role_del(this,'{{$item->id}}')"   class="label label-danger radius">删除</a>--}}
                                    {{--@endcan--}}
                                @endif
                            </td>
                        @endif
                    </tr>
                @endforeach
                </tbody>
            @endif
        </table>
        <div id="pull_right">
            <div class="pull-right">
                {!! $page->render() !!}
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script type="text/javascript">
        /*管理员-角色-添加*/
        function admin_role_add(title,url,w,h){
            layer_show(title,url,w,h);
        }
        /*管理员-角色-编辑*/
        function admin_role_edit(title,url,id,w,h){
            layer_show(title,url,w,h);
        }
        /*管理员-角色-删除*/
        function admin_role_del(obj,id){
            layer.confirm('角色删除需谨慎，确认要删除吗？',function(index){
                $.ajax({
                    type: 'POST',
                    url: '/admin/role/'+id,
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data:{'_method':'DELETE'},
                    success: function(data){
                        if(data.code == 0) {
                            $(obj).parents("tr").remove();
                            layer.msg(data.message, {icon: 1, time: 1000});
                        }else{
                            layer.msg(data.message, {icon: 2, time: 1000});
                        }
                    },
                    error:function(data) {
                        layer.msg('系统错误', {icon: 2, time: 1000});
                    },
                });
            });
        }

        function datadel(){
            var arr = []
            $('tbody :checkbox').each(function(){
                $(this).is(":checked") && arr.push($(this).parent().next().text())
            })
            console.log(arr)
        }
    </script>
@endsection