@extends('Layouts.iframe')
@section('content')
    <div class="page-container">
        <form action="" method="post" class="form form-horizontal" id="form-category-add">
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2">
                    <span class="c-red">*</span>
                    速度名称：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="name" id="title">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2">关键字：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="key" >
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2">价格：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="value">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2">上限：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="up">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2">下限：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="down">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-2">备注：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text" value="" placeholder="" name="remark">
                </div>
            </div>
            <div class="row cl">
                <div class="col-9 col-offset-2">
                    <button onClick="category_save_submit();" class="btn btn-primary radius" type="submit"><i class="Hui-iconfont">&#xe632;</i> 提交</button>
                </div>
            </div>
        </form>
    </div>
@section('js')
    <!--请在下方写此页面业务相关的脚本-->
    <script type="text/javascript" src="/js/lib/jquery.validation/1.14.0/jquery.validate.js"></script>
    <script type="text/javascript" src="/js/lib/jquery.validation/1.14.0/validate-methods.js"></script>
    <script type="text/javascript" src="/js/lib/jquery.validation/1.14.0/messages_zh.js"></script>
    <script type="text/javascript">
        function category_save_submit(){
            $("#form-category-add").validate({
                rules:{
                    name:{
                        required:true,
                    }
                },
                onkeyup:false,
                focusCleanup:true,
                success:"valid",
                submitHandler:function(form) {
                    $(form).ajaxSubmit({
                        type: 'post',
                        url: "{{ url('admin/setting') }}" ,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(data){
                            if(data.code == 0) {
                                layer.msg(data.message, {icon: 1, time: 2000},function () {
                                    window.parent.location.reload();
                                });

                                setTimeout(function(){
                                    window.parent.location.reload();
                                },2000);
                            }else{
                                layer.msg(data.message, {icon: 2, time: 2000});
                            }

                        },
                        error: function(XmlHttpRequest, textStatus, errorThrown){
                            layer.msg('error!',{icon:2,time:2000});
                        }
                    });
                    /* var index = parent.layer.getFrameIndex(window.name);
                     //parent.$('.btn-refresh').click();
                     parent.layer.close(index);*/
                }
            });
        }
    </script>
@endsection