@extends('Layouts.iframe')
@section('content')
<article class="page-container">
    <form action="{{route('tag.store')}}" method="post" class="form form-horizontal" id="form-tag-add" enctype="multipart/form-data">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <div class="row cl">
            <label class="form-label col-xs-3 col-sm-3"><span class="c-red">*</span>标签类别：</label>
            <div class="formControls col-xs-6 col-sm-6">
                <span class="select-box">
                    <select name="pid" class="select {{$errors->has('pid')?'error':''}}">
                        <option value="0">顶级</option>
                        @if($tags->count())
                            @foreach($tags as $tag)
                                <option value="{{$tag->id}}">├{{$tag->name}}</option>
                            @endforeach
                        @endif
                    </select>
                    @if($errors->has('pid'))
                        <label id="pid-error" class="error" for="pid">{{$errors->first('pid')}}</label>
                    @endif
				</span>
            </div>
        </div>
        <div class="row cl">
            <label class="form-label col-xs-3 col-sm-3"><span class="c-red">*</span>标签名称：</label>
            <div class="formControls col-xs-6 col-sm-6">
                <input type="text" class="input-text {{$errors->has('name')?'error':''}}" maxlength="10" value="{{old('name')}}" placeholder="" id="name" name="name">
                @if($errors->has('name'))
                    <label id="name-error" class="error" for="name">{{$errors->first('name')}}</label>
                @endif
            </div>
        </div>
        {{--@can('tag.store')--}}
            <div class="row cl">
                <div class="col-xs-6 col-sm-6 col-xs-offset-3 col-sm-offset-3">
                    <input class="btn btn-primary radius" type="submit" value="&nbsp;&nbsp;提交&nbsp;&nbsp;">
                </div>
            </div>
        {{--@endcan--}}
    </form>
</article>
@endsection
@section('js')

@endsection
