@extends('Layouts.iframe')
@section('content')
    <article class="page-container">
        <form action="{{route('tag.update',['id'=>$model->id])}}" method="post" class="form form-horizontal" id="form-tag-add" enctype="multipart/form-data">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="_method" value="put">
            <div class="row cl">
                <label class="form-label col-xs-3 col-sm-3"><span class="c-red">*</span>标签类别：</label>
                <div class="formControls col-xs-6 col-sm-6">
                <span class="select-box">
                    <select name="pid" class="select {{$errors->has('pid')?'error':''}}">
                        <option value="0">顶级</option>
                        @if($tags->count())
                            @foreach($tags as $tag)
                                <option value="{{$tag->id}}" {{$model->pid==$tag->id?'selected':''}}>├{{$tag->name}}</option>
                            @endforeach
                        @endif
                    </select>
                    @if($errors->has('pid'))
                        <label id="pid-error" class="error" for="pid">{{$errors->first('pid')}}</label>
                    @endif
				</span>
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-3 col-sm-3"><span class="c-red">*</span>标签名称：</label>
                <div class="formControls col-xs-6 col-sm-6">
                    <input type="text" class="input-text {{$errors->has('name')?'error':''}}" maxlength="10" value="{{old('name',$model->name)}}" placeholder="" id="name" name="name">
                    @if($errors->has('name'))
                        <label id="name-error" class="error" for="name">{{$errors->first('name')}}</label>
                    @endif
                </div>
            </div>
            @can('tag.update')
                <div class="row cl">
                    <div class="col-xs-6 col-sm-6 col-xs-offset-3 col-sm-offset-3">
                        <input class="btn btn-primary radius" type="submit" value="&nbsp;&nbsp;提交&nbsp;&nbsp;">
                        <input class="btn btn-danger radius" type="button" onclick="tag_del('{{$model->id}}')" value="&nbsp;&nbsp;删除&nbsp;&nbsp;">
                    </div>
                </div>
            @endcan
        </form>
    </article>
@endsection
@section('js')
    <script>
        /*标签删除*/
        function tag_del(id) {
            layer.confirm('确认要删除吗？', function (index) {
                $.ajax({
                    type: 'POST',
                    url: "{{url('admin/tag')}}/"+id,
                    data:{'_method':'DELETE','_token':"{{csrf_token()}}"},
                    dataType: 'json',
                    success: function (data) {
                        if(data.status===200){
                            layer.msg('删除成功!', {icon: 1, time: 2000});
                            setTimeout(function () {
                                parent.location.href='{{route('tag.index')}}';
                            },1000);
                        }else {
                            layer.msg(data.msg, {icon: 2, time: 2000});
                        }
                    }
                });
            });
        }
    </script>
@endsection
