@extends('Layouts.iframe')
@section('content')
    <style>
        .label-container{
            line-height: 3;
        }
        .label-container a{
            margin-left: 2%;
        }
    </style>
    <nav class="breadcrumb"><i class="Hui-iconfont">&#xe67f;</i> 首页 <span class="c-gray en">&gt;</span> 标签管理 <span class="c-gray en">&gt;</span> 标签列表 <a class="btn btn-success radius r" style="line-height:1.6em;margin-top:3px" href="javascript:location.replace(location.href);" title="刷新" ><i class="Hui-iconfont">&#xe68f;</i></a></nav>
    <div class="page-container">
        @can('tag.create')
        <div class="cl pd-5 bg-1 bk-gray mt-20">
            <span class="r">
                <a class="btn btn-primary radius" onclick="tag_add('添加标签','{{route('tag.create')}}','600','300')" href="javascript:;">
                    <i class="Hui-iconfont">&#xe600;</i>新增标签
                </a>
            </span>
        </div>
        @endcan

        <div class="form">
            @if($tags->count())
                @foreach($tags as $tag)
                    <div class="row cl">
                        <p class="form-label col-sm-4"><strong>{{$tag->name}}：
                                @can('tag.edit')
                                <span class="label label-primary radius" style="cursor: pointer" onclick="tag_add('修改标签','{{route('tag.edit',['id'=>$tag->id])}}','600','300')">编辑</span>
                                @endcan
                            </strong></p>
                        <div class="formControls col-xs-12 col-sm-12 label-container">
                            @if($tag->child->count())
                                @foreach($tag->child as $child)
                                    <a class="btn btn-success radius" {{--@can('tag.edit')--}} onclick="tag_add('修改标签','{{route('tag.edit',['id'=>$child->id])}}','600','300')" {{--@endcan--}} href="javascript:;">{{$child->name}}</a>
                                @endforeach
                            @endif
                        </div>
                    </div>
                @endforeach
            @endif
        </div>


    </div>
@endsection
@section('js')
    <script>
        /*标签-添加/编辑*/
        function tag_add(title,url,w,h){
            layer_show(title,url,w,h);
        }
        /*标签删除*/
        function tag_del(obj, id) {
            layer.confirm('确认要删除吗？', function (index) {
                $.ajax({
                    type: 'POST',
                    url: "{{url('admin/tag')}}/"+id,
                    data:{'_method':'DELETE','_token':"{{csrf_token()}}"},
                    dataType: 'json',
                    success: function (data) {
                        if(data.status===200){
                            $(obj).parents("li").remove();
                            layer.msg('删除成功!', {icon: 1, time: 2000});
                        }else {
                            layer.msg(data.msg, {icon: 1, time: 2000});
                        }
                    },
                    error: function (data) {
                        layer.msg(data.msg, {icon: 1, time: 2000});
                        console.log(data.msg);
                    },
                });
            });
        }
    </script>
@endsection