@extends('Layouts.iframe')
@section('content')
    <nav class="breadcrumb"><i class="Hui-iconfont">&#xe67f;</i> 首页 <span class="c-gray en">&gt;</span> 日志管理 <span class="c-gray en">&gt;</span> 日志列表
        {{--<a class="btn btn-success radius r" style="line-height:1.6em;margin-top:3px" href="javascript:location.replace(location.href);" title="刷新" ><i class="Hui-iconfont">&#xe68f;</i></a>--}}
        <a class="btn btn-success radius r" style="line-height:1.6em;margin-top:3px" href="{{ url('admin/worklog') }}" title="重置" ><i class="Hui-iconfont">&#xe68f;</i></a>
    </nav>
    <div class="page-container">
        <form action="/admin/viewTask/readBrushOne" method="get" id="product-search">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <div class="text-c">
                日期范围：
                <input type="text" onfocus="WdatePicker({ maxDate:'#F{$dp.$D(\'datemax\')||\'%y-%M-%d\'}' })"
                       id="datemin" class="input-text Wdate" style="width:120px;"  autocomplete="off"
                       @if(isset($data['start'])) value="{{$data['start']}}"  @endif  name="start">
                -
                <input type="text" onfocus="WdatePicker({ minDate:'#F{$dp.$D(\'datemin\')}',maxDate:'%y-%M-%d' })" id="datemax" class="input-text Wdate" style="width:120px;" name="end"  @if(isset($data['end'])) value="{{$data['end']}}"  @endif  name="end" autocomplete="off" >
                <button type="submit" class="btn btn-success" id="" name="" ><i class="Hui-iconfont">&#xe665;</i> 搜索 </button>
            </div>
        </form>
        <div class="cl pd-5 bg-1 bk-gray mt-20">
            <span class="l">
               {{-- <a href="javascript:;" onclick="admin_add('添加日志','{{ url('admin/worklog/create')  }}','900','700')" class="btn btn-primary radius"><i class="Hui-iconfont">&#xe600;</i> 添加日志</a>--}}
            </span> <span class="r">共有数据：<strong>{{ $page->total() }}</strong> 条</span> </div>
        <table class="table table-border table-bordered table-bg">
            <thead>
            <tr>
                <th scope="col" colspan="10">日志列表</th>
            </tr>
            <tr class="text-c">
                <th width="20">编号</th>
                <th width="80">登录名</th>
                <th width="100">邮箱</th>
                <th width="100">状态</th>
                <th width="40">余额</th>
                <th width="150">最后登录IP</th>
                <th width="150">随后登录地点</th>
                <th width="150">注册时间</th>
                <th width="150">操作</th>
            </tr>
            </thead>
            <tbody>
            @if($page)
                @foreach($page as$key=> $item)
                    <tr class="text-c">
                        <td>{{$item->id}}</td>
                        <td>{{$item->mobile}}</td>
                        <td>{{$item->email}}</td>
                        <td>
                            @if($item->status == 1)
                                正常
                            @else
                                禁用
                            @endif
                        </td>
                        <td>{{$item->money}}</td>

                        <td>{{$item->last_login_ip}}</td>
                        <td>{{$item->last_login_time}}</td>
                        <td>{{$item->created_at}}</td>
                        <td>
                            <a title="编辑" href="javascript:;" onclick="admin_edit('编辑','/admin/users/{{$item->id}}/edit','','900','700')"
                               style="text-decoration:none" class="label label-primary  radius">编  辑</a>
                            <a title="禁用" href="javascript:;" onclick="admin_del(this,'{{ $item->id }}')"
                               class="label label-danger radius" style="text-decoration:none" >禁用</a>
                              <a title="删除" href="javascript:;" onclick="admin_del(this,'{{ $item->id }}')"
                                 class="label label-danger radius" style="text-decoration:none" >删除</a>
                        </td>
                    </tr>
                @endforeach
            @endif
            </tbody>
        </table>
        <div id="pull_right">
            <div class="pull-right">
                {{ $page->appends(['end'=>$data['end'],'start'=>$data['end']])->links() }}
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript" src="/js/lib/WdatePicker.js"></script>
    <script type="text/javascript">
        /*
         参数解释：
         title	标题
         url		请求的url
         id		需要操作的数据id
         w		弹出层宽度（缺省调默认值）
         h		弹出层高度（缺省调默认值）
         */
        /*增加*/
        function admin_add(title,url,w,h){
            layer_show(title,url,w,h);
        }
        /*删除*/
        function admin_del(obj,id){
            layer.confirm('确认要删除吗？',function(index){
                $.ajax({
                    type: 'POST',
                    url: '/admin/worklog/'+id,
                    dataType: 'json',
                    data:{'_method':'DELETE'},
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(data){
                        if(data.code == 0) {
                            $(obj).parents("tr").remove();
                            layer.msg('已删除!', {icon: 1, time: 1000},function () {
                                window.location.href='/admin/overtime';
                            });
                        }else{
                            layer.msg(data.message, {icon: 2, time: 1000});
                        }
                    },
                    error:function(data) {
                        layer.msg('系统错误', {icon: 2, time: 1000});
                    },
                });
            });
        }
        /*编辑*/
        function admin_edit(title,url,id,w,h){
            layer_show(title,url,w,h);
        }
        /*编辑*/
        function show(title,url,id,w,h){
            layer_show(title,url,w,h);
        }
    </script>
@endsection