@extends('Layouts.iframe')
@section('content')
    <article class="page-container">
        <form class="form form-horizontal" id="form-overtime-add" method="post" action="">
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>发布人：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->userInfo->mobile}}" readonly id="uid" name="uid" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>公众号名称：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->wechat_name}}" id="require_views"
                           name="require_views" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>公众号账号：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->wechat_account}}" id="require_views"
                           name="require_views" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>文章标题：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->title}}" id="title" name="title" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>文章链接：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->url}}" id="url" name="url" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>点赞需求：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->require_likes}}" id="require_likes"
                           name="require_likes" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">速度类型：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" value="{{$show->speed->name}}/{{$show->speed->value}}元"
                           style="width:300px;" readonly>
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3"><span class="c-red">*</span>接单价格：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="number" class="input-text" value="{{$show->price}}" id="price" name="price" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">接单人：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    <input type="text" class="input-text" @if(isset($show->acceptInfo))   value="{{$show->acceptInfo->mobile}}"
                           @else value="" @endif  id="accept_uid" name="accept_uid" style="width:300px;">
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">任务进度：</label>
                <div class="formControls col-xs-8 col-sm-9 skin-minimal">
                    <div class="radio-box">
                        <input name="status" type="radio" id="sex-1" @if($show->status == 1) checked @endif   value="1">
                        <label for="sex-1">接单</label>
                    </div>
                    <div class="radio-box">
                        <input name="status" type="radio" id="sex-2"  @if($show->status == 2) checked @endif value="2">
                        <label for="sex-2">完成</label>
                    </div>
                    <div class="radio-box">
                        <input  name="status" type="radio" id="sex-3" @if($show->status == 3) checked @endif value="3">
                        <label for="sex-4">取消</label>
                    </div>
                    <div class="radio-box">
                        <input name="status" type="radio" id="sex-4" @if($show->status == 4) checked @endif value="4">
                        <label for="sex-4">未完成</label>
                    </div>
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">结算：</label>
                <div class="formControls col-xs-8 col-sm-9 skin-minimal">
                    <div class="radio-box">
                        <input name="pay_status" type="radio" id="pay_status-1" @if( isset($show->crontab) && $show->crontab->pay_status == 1) checked @endif value="1">
                        <label for="pay_status-1">未结算</label>
                    </div>
                    <div class="radio-box">
                        <input  name="pay_status" type="radio" id="pay_status-2" @if(isset($show->crontab) && $show->pay_status == 2) checked @endif value="2">
                        <label for="pay_status-2">已结算</label>
                    </div>
                </div>
            </div>
            <div class="row cl">
                <label class="form-label col-xs-4 col-sm-3">任务类型：</label>
                <div class="formControls col-xs-8 col-sm-9">
                    @if($show->task_type == 'view')
                        <span>刷阅读量</span>
                    @else
                        <span>微信公众号增粉</span>
                    @endif
                </div>
            </div>
            <div class="row cl" >
                <div class="col-xs-8 col-sm-9 col-xs-offset-4 col-sm-offset-3">
                    <input class="btn btn-primary radius" type="submit" value="&nbsp;&nbsp;确认修改&nbsp;&nbsp;">
                </div>
            </div>
            <input type="hidden" name="_token" value="{{csrf_token()}}">
        </form>
    </article>
@endsection
@section('js')
    <script>
        $(function(){
            $("#form-overtime-add").validate({
                rules:{
                    name:{
                        required:true,
                    },
                    title:{
                        required:true,
                    },
                    url:{
                        required:true,
                    },
                    require_likes:{
                        required:true,
                    },
                    price:{
                        required:true,
                    },
                },
                messages: {
                },
                onkeyup:false,
                focusCleanup:true,
                success:"valid",
                submitHandler:function(form){
                    $(form).ajaxSubmit({
                        type: 'post',
                        url: "{{ url('admin/weChatTask') }}"+'/{{$show->id}}',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data:{'_method':'PUT'},
                        success: function(data){
                            if(data.code == 0) {
                                layer.msg(data.message, {icon: 1, time: 2000},function () {
                                    window.parent.location.reload();
                                });

                                setTimeout(function(){
                                    window.parent.location.reload();
                                    /*var index = parent.layer.getFrameIndex(window.name);
                                     parent.$('.btn-refresh').click();
                                     parent.layer.close(index);*/
                                },2000);
                            }else{
                                console.log('a');
                                layer.msg(data.message, {icon: 2, time: 2000});
                            }

                        },
                        error: function(XmlHttpRequest, textStatus, errorThrown){
                            layer.msg('error!',{icon:2,time:2000});
                        }
                    });
                }
            });
        });
    </script>
@endsection
