@extends('Layouts.iframe')
@section('content')
    <nav class="breadcrumb"><i class="Hui-iconfont">&#xe67f;</i> 首页 <span class="c-gray en">&gt;</span> 日志管理 <span class="c-gray en">&gt;</span> 日志列表
        {{--<a class="btn btn-success radius r" style="line-height:1.6em;margin-top:3px" href="javascript:location.replace(location.href);" title="刷新" ><i class="Hui-iconfont">&#xe68f;</i></a>--}}
        <a class="btn btn-success radius r" style="line-height:1.6em;margin-top:3px" href="{{ url('admin/worklog') }}" title="重置" ><i class="Hui-iconfont">&#xe68f;</i></a>
    </nav>
    <div class="page-container">
        <form action="/admin/viewTask/readBrushOne" method="get" id="product-search">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <div class="text-c">
                日期范围：
                <input type="text" onfocus="WdatePicker({ maxDate:'#F{$dp.$D(\'datemax\')||\'%y-%M-%d\'}' })"
                       id="datemin" class="input-text Wdate" style="width:120px;"  autocomplete="off"
                       @if(isset($data['start'])) value="{{$data['start']}}"  @endif  name="start">
                -
                <input type="text" onfocus="WdatePicker({ minDate:'#F{$dp.$D(\'datemin\')}',maxDate:'%y-%M-%d' })" id="datemax" class="input-text Wdate" style="width:120px;" name="end"  @if(isset($data['end'])) value="{{$data['end']}}"  @endif  name="end" autocomplete="off" >
                <button type="submit" class="btn btn-success" id="" name="" ><i class="Hui-iconfont">&#xe665;</i> 搜索 </button>
            </div>
        </form>
        <div class="cl pd-5 bg-1 bk-gray mt-20">
            <span class="l">
               {{-- <a href="javascript:;" onclick="admin_add('添加日志','{{ url('admin/worklog/create')  }}','900','700')" class="btn btn-primary radius"><i class="Hui-iconfont">&#xe600;</i> 添加日志</a>--}}
            </span> <span class="r">共有数据：<strong>{{ $page->total() }}</strong> 条</span> </div>
        <table class="table table-border table-bordered table-bg">
            <thead>
            <tr>
                <th scope="col" colspan="10">公众号增粉</th>
            </tr>
            <tr class="text-c">
                <th width="20">编号</th>
                <th width="80">发布人姓名</th>
                <th width="150">文章标题</th>
                <th width="100">文章链接</th>
                <th width="100">公众号名称</th>
                <th width="100">公众号账户</th>
                <th width="100">速度分类</th>
                <th width="60">点赞需求</th>
                <th width="60">单价</th>
                <th width="80">接单人</th>
                <th width="100">接单时间</th>
                <th width="100">任务进度</th>
                <th width="100">任务详情</th>
                <th width="100">操作</th>
            </tr>
            </thead>
            <tbody>
            @if($page)
                @foreach($page as$key=> $item)
                    <tr class="text-c">
                        <td>{{$item->id}}</td>
                        <td>{{$item->userInfo->mobile}}</td>
                        <td>{{$item->title}} </td>
                        <td>{{$item->url}}</td>
                        <td>{{$item->wechat_name}}</td>
                        <td>{{$item->wechat_account}}</td>
                        <td>{{$item->speed->name}}/ <span style="color: #00a65a">{{$item->speed->value}}元 </span></td>
                        <td>{{$item->require_likes}} </td>
                        <td>{{$item->price}}</td>
                        <td>
                            @if($item->acceptInfo)
                                {{$item->acceptInfo->name}}
                            @endif
                        </td>
                        <td>{{$item->accept_time}}</td>
                        <td>
                            @if($item->status == 1)
                                接单中
                            @elseif($item->status == 2)
                                已完成
                            @elseif($item->status == 3)
                                已取消
                            @else
                                未完成
                            @endif
                        </td>
                        <td><a href="">任务详情</a></td>
                        <td>
                            <a title="编辑" href="javascript:;" onclick="admin_edit('编辑','/admin/weChatTask/{{$item->id}}/edit','','900','700')"
                               style="text-decoration:none" class="label label-primary  radius">编  辑</a>
                            <a title="删除" href="javascript:;" onclick="admin_del(this,'{{ $item->id }}')"
                               class="label label-danger radius" style="text-decoration:none" >删除</a>
                        </td>
                    </tr>
                @endforeach
            @endif
            </tbody>
        </table>
        <div id="pull_right">
            <div class="pull-right">
                {{ $page->appends(['end'=>$data['end'],'start'=>$data['end']])->links() }}
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript" src="/js/lib/WdatePicker.js"></script>
    <script type="text/javascript">
        /*
         参数解释：
         title	标题
         url		请求的url
         id		需要操作的数据id
         w		弹出层宽度（缺省调默认值）
         h		弹出层高度（缺省调默认值）
         */
        /*增加*/
        function admin_add(title,url,w,h){
            layer_show(title,url,w,h);
        }
        /*删除*/
        function admin_del(obj,id){
            layer.confirm('确认要删除吗？',function(index){
                $.ajax({
                    type: 'POST',
                    url: '/admin/worklog/'+id,
                    dataType: 'json',
                    data:{'_method':'DELETE'},
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(data){
                        if(data.code == 0) {
                            $(obj).parents("tr").remove();
                            layer.msg('已删除!', {icon: 1, time: 1000},function () {
                                window.location.href='/admin/overtime';
                            });
                        }else{
                            layer.msg(data.message, {icon: 2, time: 1000});
                        }
                    },
                    error:function(data) {
                        layer.msg('系统错误', {icon: 2, time: 1000});
                    },
                });
            });
        }
        /*编辑*/
        function admin_edit(title,url,id,w,h){
            layer_show(title,url,w,h);
        }
        /*编辑*/
        function show(title,url,id,w,h){
            layer_show(title,url,w,h);
        }
    </script>
@endsection