@extends('Home.layout')
@section('content')
    <div class="layui-card">
        <div class="layui-card-header">余额变化记录</div>
        <div class="layui-card-body">
            <div class="layui-tab layui-tab-brief" lay-filter="user-record-tabs">
                <ul class="layui-tab-title">
                    <li class="layui-this checkType" data-type="0" >全部记录</li>
                    <li class="checkType" data-type="2">消耗记录</li>
                    <li class="checkType" data-type="1">获得记录</li>
                </ul>
                 <table id="dataTable" lay-filter="dataTable"></table>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['layer','table','form'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                , url: "{{ route('balance.changeDate')}}" //数据接口
                , where: {type: ''}
                , page: true //开启分页
                , cols: [[ //表头
                    {checkbox: true, fixed: true}
                    , {field: 'id', title: '序号', sort: true, width: 80}
                    , {field: 'created_at', title: '时间'}
                    , {field: 'remark', title: '具体事项'}
                    , {field: 'money', title: '余额变化'}
                ]]
            });
            //监听工具条
            table.on('tool(dataTable)', function (obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    , layEvent = obj.event; //获得 lay-event 对应的值
                if (layEvent === 'del') {
                    layer.confirm('确认删除吗？', function (index) {
                        $.post("{{ route('view.destroy') }}", {_method: 'delete', id: data.id}, function (result) {
                            if (result.code == 1) {
                                layer.msg(result.info);
                                obj.del(); //删除对应行（tr）的DOM结构
                            } else {
                                layer.msg(result.info)
                            }
                            layer.close(index);
                        });
                    });
                } else if (layEvent === 'edit') {
                    location.href = '/view/' + data.id + '/edit';
                }
            });
            //搜索
            $("#memberSearch").click(function () {

            })

            $('.checkType').click(function(){
                var type = parseInt($(this).attr('data-type'))
                dataTable.reload({
                    where: { type: type},
                    page: {curr: 1}
                })

            });
            {{--{{ route('admin.member.destroy') }}--}}

        })

    </script>
@endsection