@extends('Home.layout')
@section('content')
    <div class="layui-card">
        <form class="layui-form" action="{{route('home.member.profile')}}" method="post">
            {{csrf_field()}}
        <div class="layui-form" lay-filter="">
            <div class="layui-form-item">
                <label class="layui-form-label">会员等级</label>
                <div class="layui-input-inline">
                    <select name="role" lay-verify="">
                        @if($info->agent_id)
                        <option value="3" selected>我是代理</option>
                        @elseif(count($info->recharge))
                        <option value="2" selected>VIP会员</option>
                        @else
                        <option value="1" selected>普通会员</option>
                        @endif
                    </select>
                </div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label">手机</label>
                <div class="layui-input-inline">
                    <input type="text" name="username" value="{{$info->mobile}}" readonly="" class="layui-input">
                </div>
                <div class="layui-form-mid layui-word-aux">不可修改。一般用于后台登入名</div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label">昵称</label>
                <div class="layui-input-inline">
                    <input type="text" name="nickname" value="{{ $info->username??'' }}" lay-verify="nickname" autocomplete="off" placeholder="请输入昵称" class="layui-input">
                </div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label">性别</label>
                <div class="layui-input-block">
                    <input type="radio" name="sex" value="男" title="男" @if($info->sex == '男') checked @endif><div class="layui-unselect layui-form-radio"><i class="layui-anim layui-icon"></i><div>男</div></div>
                    <input type="radio" name="sex" value="女" title="女"  @if($info->sex == '女') checked @endif><div class="layui-unselect layui-form-radio layui-form-radioed"><i class="layui-anim layui-icon"></i><div>女</div></div>
                </div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label">邮箱</label>
                <div class="layui-input-inline">
                    <input type="text" name="email" value="{{ $info->email ?? '' }}" lay-verify="" autocomplete="off" class="layui-input">
                </div>
            </div>
            <div class="layui-form-item layui-form-text">
                <label class="layui-form-label">个性签名</label>
                <div class="layui-input-block">
                    <textarea name="remarks" placeholder="请输入内容" class="layui-textarea">{{ $info->remark ?? '' }}</textarea>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="setmyinfo">确认修改</button>
                    <a type="reset" class="layui-btn layui-btn-primary" href="{{ route('home.index') }}">返回</a>
                </div>
            </div>
        </div>
        </form>
    </div>
@endsection
