@extends('Home.layout')
@section('content')
    <div class="layui-card">
        <div class="layui-card-header text-center"><h2>抖音点赞</h2></div>
        <div class="layui-card-body layui-text layadmin-text biz_desc">
            <p class="color-notice">【暂停说明】任务提交后，不能暂停或撤销</p>
            <p>【收费说明】价格动态波动，以提交时价格为主，费用一次性收取</p>
            <p>【客服问题】如果有疑问或者其他问题，请加客户QQ：1946919250</p>
            <p>【刷量问题】转发刷量只支持100个起刷，只支持倍数起刷</p>
        </div>
    </div>
    <div class="layui-card">
        <div class="layui-card-header">提交任务</div>
        <div class="layui-card-body">
            <form class="layui-form" lay-filter="addTaskForm">
                <div class="layui-row layui-col-space10 layui-form-item">
                    <div class="layui-col-lg9">
                        <label class="layui-form-label">作品链接：</label>
                        <div class="layui-input-block">
                            <input type="text" name="url" placeholder="请输入作品链接" autocomplete="off" class="layui-input">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">转发类型：</label>
                    @foreach($speeds as $k=> $item)
                        <div class="layui-input-block">
                            <input type="radio" name="speed" value="{{$item->id}}"   @if($k == 0)  checked  @endif
                            title="{{$item->name}}（<b>价格:{{$item->value}}元/百</b>{{','.$item->remark}}）" data="{{$item->value}}">
                            <div class="layui-unselect layui-form-radio layui-form-radioed">
                                <i class="layui-anim layui-icon"></i>
                                <div>{{$item->id}}（<b>价格:{{$item->value}}元/百</b>{{','.$item->remark}}）</div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="layui-form-item layui-col-md6 layui-col-sm8 layui-col-xs10 layui-col-lg6">
                    <label class="layui-form-label">分享数量：</label>
                    <div class="layui-input-block">
                        <input type="number" name="require_like" placeholder="请输入分享数量，最低100" oninput="sumMoney()"
                               autocomplete="off" class="layui-input">
                        <p id="scoreTip" style="display: block;">
                            <input type="hidden" name="money" value="@if($user) {{$user->money}} @else  0  @endif "  data="@if($user) {{$user->id}} @endif ">
                            <span class="color-notice">总需币:<span id="count_">0</span>币 ≈ <span id="money_">0</span>元 (余额:@if($user) {{$user->money}} @else  0  @endif币)</span>
                            <a class="layui-btn layui-btn-xs layui-btn-radius" href="{{route('recharge.create')}}" style="display: inline-block;">立即充值</a>
                            <br><em class="color-notice" style="font-style: unset;">注意：任务提交后，不能暂停或撤销</em>
                        </p>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <div class="layui-btn"  id="viewTaskAdd">立即提交</div>
                    </div>
                </div>
            </form>
            <!--<div style="top: 0;left: 0;position: absolute;z-index: 1000;height: 100%;width: 100%;background-color: rgba(187,187,187,0.62)"></div>-->
        </div>
    </div>
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <div class="layui-form">
                任务ID:
                <div class="layui-input-inline">
                    <input type="number" name="id" id="id" placeholder="任务ID" class="layui-input">
                </div>
                抖音号：
                <div class="layui-input-inline">
                    <input type="text" name="trill_id" id="trill_id" placeholder="抖音号" class="layui-input">
                </div>
                {{--  链接：
                  <div class="layui-input-inline">
                      <input type="text" name="url" id="url" placeholder="文章链接" class="layui-input">
                  </div>--}}
                状态：
                <div class="layui-input-inline">
                    <select name="status" lay-verify="required" id="status">
                        <option value="0">所有</option>
                        <option value="1">进行中</option>
                        <option value="2">已完成</option>
                    </select>
                </div>
                <button class="layui-btn layui-btn-sm" id="memberSearch">搜索</button>
            </div>
        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @{{# if(d.status =="0"){}}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">编辑</a>
                    <span style="margin-right: 20px"></span>
                    <a class="layui-btn layui-btn-danger layui-btn-sm" lay-event="del">删除</a>
                    @{{# }}}
                </div>
            </script>
            <script type="text/html" id="avatar">
                <a href="@{{d.avatar}}" target="_blank" title="点击查看"><img src="@{{d.avatar}}" alt="" width="28" height="28"></a>
            </script>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['layer','table','form'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "{{ route('trill.date')}}" //数据接口
                ,where:{type:4}
                ,page: true //开启分页
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID', sort: true,width:80}
                    ,{field: 'url', title: '链接'}
                    ,{field: 'speed_id', title: '速度',templet: function(d){
                        return d.speed.name+':'+d.speed.value+'元/百'
                    }}
                    ,{field: 'price', title: '单价'}
                    ,{field: 'require_like', title: '所需粉丝数量'}
                    ,{field: 'status', title: '已完成任务', sort: true,templet: function(d){
                        if(d.status=='0'){
                            return '待接单'
                        }else if(d.status=='1'){
                            return '进行中'
                        } else if(d.status=='2'){
                            return '已完成'
                        }
                    }}
                    ,{field: 'created_at', title: '提交时间'}
                    ,{field: 'status', title: '状态', sort: true,templet: function(d){
                        if(d.status=='0'){
                            return '待接单'
                        }else if(d.status=='1'){
                            return '进行中'
                        } else if(d.status=='2'){
                            return '已完成'
                        }
                    }}
                    ,{fixed: 'right', title: '操作', width: 120, align:'center', toolbar: '#options'}
                ]]
            });
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('trill.destroy') }}",{_method:'delete',id:data.id},function (result) {
                            if (result.code==1){
                                layer.msg(result.message);
                                obj.del(); //删除对应行（tr）的DOM结构
                            }else
                            {
                                layer.msg(result.message)
                            }
                            layer.close(index);
                        });
                    });
                } else if(layEvent === 'edit'){
                    location.href = '/trill/'+data.id+'/edit';
                }
            });
            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("",{_method:'delete',ids:ids},function (result) {
                            if (result.code==0){
                                dataTable.reload()
                            }
                            layer.close(index);
                            layer.msg(result.msg)
                        });
                    })
                }else {
                    layer.msg('请选择删除项')
                }
            })
            //搜索
            $("#memberSearch").click(function () {
                var id = $("#id").val()
                var trill_id = $("#trill_id").val();
                var url = $("#url").val();
                var status = $("#status").val();
                dataTable.reload({
                    where:{id:id,trill_id:trill_id,url:url,status:status,type:4},
                    page:{curr:1}
                })
            })
            {{--{{ route('admin.member.destroy') }}--}}
            //提交
            $("#viewTaskAdd").click(function () {
                var url = $("input[name='url']").val();
                var speed = $("input[name='speed']:checked").val();
                var require_like = $("input[name='require_like").val();
                var money = $("input[name='money").val();
                var count  = parseFloat($("#count_").html())/1000;
                var id = $("input[name='money").attr('data');
                if(!parseInt(id))
                {
                    layer.msg('请先登录');
                    setTimeout(function(){
                        parent.location.href='/login'
                    },2000);
                    return false;
                }
                if(money < count)
                {
                    layer.msg('余额不足请充值');
                    return false;
                }
                if(!url)
                {
                    layer.msg('请输入链接');
                    return false;
                }else if(!speed)
                {
                    layer.msg('请选择速度类型');
                    return false;
                }else if(!require_like)
                {
                    layer.msg('请输入需要的粉丝数量');
                    return false;
                }else if(require_like < 100)
                {
                    layer.msg('转发数量不能低于100');
                    return false;
                }else{
                    layer.confirm('确认提交任务吗？', function(index){
                        $.post("{{ route('trill.post.cron') }}",
                            {type:4,url:url,speed:speed,require_like:require_like},function (result) {
                                if(result.code == 1 )
                                {
                                    layer.close(index);
                                    layer.msg(result.msg)
                                    window.location.reload();
                                }else{
                                    layer.close(index);
                                    layer.msg(result.msg)
                                }
                            });
                    });
                }
            });
        })

        function  sumMoney() {
            var value = $("input[name='require_like']").val();
            var speed_value = $("input[name='speed']:checked").attr('data');
            var sum = value * speed_value /100;
            sum =sum.toFixed(2)
            var count = value * speed_value;
            $("#count_").html(sum)
            $("#money_").html(sum)
        }
    </script>
@endsection