@extends('Home.layout')
@section('content')
    <head>
        <link rel="stylesheet" type="text/css" href="/js/layui-v1.0.4/layui/css/layui.css"/>
    </head>
    <div class="layui-card">
        <div class="layui-card-header text-center"><h2>真人活粉(需要授权)说明</h2></div>
        <div class="layui-card-body layui-text layadmin-text biz_desc">
            <p class="color-notice">【粉丝来源】真实用户，做任务关注的粉丝</p>
            <p>【增粉速度】一天可增 10000-20000粉，限地区或限性别增粉速度比较慢</p>
            <p>【上限说明】一个号可增30000-50000，需要更多活粉，可联系客服单独加粉</p>
            <p>【授权说明】必须公众号管理或运营者授权才能加粉，授权成功后请等待浏览器页面自动返回。不能授权的，可联系客服单独加粉</p>
            <p>【用户回复】部分未领取到奖励的用户会回复 888，注：只是一小部分用户会回复</p>
            <p>【取关率】20天内取关率 10-20%</p>
            <p class="color-tip">【修改关注数】如需继续增粉，请在总需粉丝数基础上继续增加，比如原来设置总需粉丝数为200，现在需要再加100，则把“总需粉丝数”修改为300即可</p>
            <p class="color-notice">【提前下线说明】正在增加的粉丝数量不足100会提前下线，比如你提交了100个粉丝，增加了60多或70多个就会自动下线，剩余的没增加粉丝的不会扣粉币，请知晓，接受不了别提交！</p>
            <p class="color-show">&nbsp;禁止提交手赚类、托管赚钱、赚钱线报类、阅读分享关注赚钱等做任务赚钱的公众号</p>
        </div>
    </div>
    <div class="layui-card">
        <div class="layui-card-header">提交任务</div>
        <div class="layui-card-body">
            <form class="layui-form" lay-filter="addTaskForm">
                <div class="layui-form-item">
                    <label class="layui-form-label">性别：</label>
                    <div class="layui-input-block">
                        <input type="radio" name="sex" value="0" title="不限" lay-filter="sex" checked="">
                        <div class="layui-unselect layui-form-radio layui-form-radioed">
                            <i class="layui-anim layui-icon"></i>
                            <div>不限</div>
                        </div>
                        <input type="radio" name="sex" value="1" title="男" lay-filter="sex">
                        <div class="layui-unselect layui-form-radio">
                            <i class="layui-anim layui-icon"></i>
                            <div>男</div>
                        </div>
                        <input type="radio" name="sex" value="2" title="女" lay-filter="sex">
                        <div class="layui-unselect layui-form-radio">
                            <i class="layui-anim layui-icon"></i>
                            <div>女</div>
                        </div>
                    </div>
                </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">选择地区</label>
                        <div class="layui-input-inline">
                            <select name="province" lay-filter="province">
                                <option value="">请选择省</option>
                            </select>
                        </div>
                        <div class="layui-input-inline" style="display: none;">
                            <select name="city" lay-filter="city">
                                <option value="">请选择市</option>
                            </select>
                        </div>

                    </div>
                     <div class="layui-form-item">
                    <label class="layui-form-label">速度类型：</label>
                    @foreach($speeds as $k=> $item)
                        <div class="layui-input-block">
                            <input type="radio" name="speed" value="{{$item->id}}"   @if($k == 0)  checked  @endif
                            title="{{$item->name}}（<b>价格:{{$item->value}}元/千</b>{{','.$item->remark}}）" data="{{$item->value}}">
                            <div class="layui-unselect layui-form-radio layui-form-radioed">
                                <i class="layui-anim layui-icon"></i>
                                <div>{{$item->id}}（<b>价格:{{$item->value}}元/千</b>{{','.$item->remark}}）</div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="layui-form-item layui-col-md6 layui-col-sm8 layui-col-xs10 layui-col-lg6">
                    <label class="layui-form-label">点赞率：</label>
                    <div class="layui-input-block">
                        <input type="number" max="25" step="1" name="zan" placeholder="暂时无法设置" autocomplete="off" class="layui-input" disabled="">
                    </div>
                </div>
                <div class="layui-form-item layui-col-md6 layui-col-sm8 layui-col-xs10 layui-col-lg6">
                    <label class="layui-form-label">总需量：</label>
                    <div class="layui-input-block">
                        <input type="number" name="require_views" placeholder="请输入期望阅读量，最低100" oninput="sumMoney()"
                               autocomplete="off" class="layui-input">
                        <p id="scoreTip" style="display: block;">
                            <input type="hidden" name="money" value="@if($user) {{$user->money}} @else  0  @endif "  data="@if($user) {{$user->id}} @endif ">
                            <span class="color-notice">总需币:<span id="count_">0</span>币 ≈ <span id="money_">0</span>元 (余额:@if($user) {{$user->money}} @else  0  @endif币)</span>
                            <a class="layui-btn layui-btn-xs layui-btn-radius" href="{{route('recharge.create')}}" style="display: inline-block;">立即充值</a>
                            <br><em class="color-notice" style="font-style: unset;">注意：任务提交后，不能暂停或撤销</em>
                        </p>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <div class="layui-btn"  id="viewTaskAdd">立即提交</div>
                    </div>
                </div>
            </form>
            <!--<div style="top: 0;left: 0;position: absolute;z-index: 1000;height: 100%;width: 100%;background-color: rgba(187,187,187,0.62)"></div>-->
        </div>
    </div>
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <div class="layui-form">
                任务ID:
                <div class="layui-input-inline">
                    <input type="number" name="id" id="id" placeholder="任务ID" class="layui-input">
                </div>
                公众号名：
                <div class="layui-input-inline">
                    <input type="text" name="wechat_name" id="wechat_name" placeholder="公众号名" class="layui-input">
                </div>
                公众号微信号：
                <div class="layui-input-inline">
                    <input type="text" name="wechat_account" id="wechat_account" placeholder="公众号微信号" class="layui-input">
                </div>
                状态：
                <div class="layui-input-inline">
                    <select name="status" lay-verify="required" id="status">
                        <option value="0">所有</option>
                        <option value="1">已暂停</option>
                        <option value="2">进行中</option>
                        <option value="3">已完成</option>
                    </select>
                </div>
                <button class="layui-btn layui-btn-sm" id="memberSearch">搜索</button>
            </div>
        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @{{# if(d.status =="0"){}}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">编辑</a>
                    <span style="margin-right: 20px"></span>
                    <a class="layui-btn layui-btn-danger layui-btn-sm" lay-event="del">删除</a>
                    @{{# }}}
                </div>
            </script>
            <script type="text/html" id="avatar">
                <a href="@{{d.avatar}}" target="_blank" title="点击查看"><img src="@{{d.avatar}}" alt="" width="28" height="28"></a>
            </script>
        </div>
    </div>
@endsection
@section('script')
    <script src="/static/area.js"></script>
    <script>0
        var areaData = Area;
        var form;
        var $;
        layui.use(['layer','table','jquery','form'],function () {
            var layer = layui.layer;

            var table = layui.table;
            $ = layui.jquery;
            var form = layui.form;
            $form = $('form');
            loadProvince();

            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "{{ route('wechat.zombiesDate')}}" //数据接口
                ,where:{type:4}
                ,page: true //开启分页
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID', sort: true,width:80}
                    ,{field: 'wechat_name', title: '公众号名称'}
                    ,{field: 'wechat_account', title: '公众号微信号'}
                    ,{field: 'speed_id', title: '速度',templet: function(d){
                            return d.speed.name+':'+d.speed.value+'元/千'
                        }}
                    ,{field: 'price', title: '单价'}
                    ,{field: 'require_collect', title: '总需量'}
                    ,{field: 'created_at', title: '提交时间'}
                    ,{field: 'status', title: '状态', sort: true,templet: function(d){
                            if(d.status=='0'){
                                return '待接单'
                            }else if(d.status=='1'){
                                return '已暂停'
                            }else if(d.status=='2'){
                                return '进行中'
                            } else if(d.status=='3'){
                                return '已完成'
                            }
                        }}
                    ,{fixed: 'right', title: '操作', width: 120, align:'center', toolbar: '#options'}
                ]]
            });
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('wechat.destroy') }}",{_method:'delete',id:data.id},function (result) {
                            if (result.code==1){
                                layer.msg(result.info);
                                obj.del(); //删除对应行（tr）的DOM结构
                            }else
                            {
                                layer.msg(result.info)
                            }
                            layer.close(index);
                        });
                    });
                } else if(layEvent === 'edit'){
                    location.href = '/wechat/'+data.id+'/edit';
                }
            });
            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("",{_method:'delete',ids:ids},function (result) {
                            if (result.code==0){
                                dataTable.reload()
                            }
                            layer.close(index);
                            layer.msg(result.msg)
                        });
                    })
                }else {
                    layer.msg('请选择删除项')
                }
            })
            //搜索
            $("#memberSearch").click(function () {
                var id = $("#id").val()
                var wechat_name = $("#wechat_name").val();
                var wechat_account = $("#wechat_account").val();
                var status = $("#status").val();
                dataTable.reload({
                    where:{id:id,wechat_name:wechat_name,wechat_account:wechat_account,status:status,type:4},
                    page:{curr:1}
                })
            })
            {{--{{ route('admin.member.destroy') }}--}}
            //提交
            $("#viewTaskAdd").click(function () {
                var wechat_name = $("input[name='wechat_name']").val();
                var wechat_account = $("input[name='wechat_account']").val();
                var speed = $("input[name='speed']:checked").val();
                var source =  $("input[name='source']:checked").val();
                var require_views = $("input[name='require_views").val();
                var money = $("input[name='money").val();
                var count  = parseFloat($("#count_").html())/1000;
                var id = $("input[name='money").attr('data');
                if(!parseInt(id))
                {
                    layer.msg('请先登录');
                    setTimeout(function(){
                        parent.location.href='/login'
                    },2000);
                    return false;
                }
                if(money < count)
                {
                    layer.msg('余额不足请充值');
                    return false;
                }
                if(!wechat_name)
                {
                    layer.msg('请输入公众号名');
                    return false;
                } else if(!wechat_account)
                {
                    layer.msg('请输入公众号微信号');
                    return false;
                }else if(!speed)
                {
                    layer.msg('请选择速度类型');
                    return false;
                }else if(!require_views)
                {
                    layer.msg('请输入总需量');
                    return false;
                }else{
                    layer.confirm('确认提交任务吗？', function(index){
                        $.post("{{ route('wechat.post.cron') }}",
                            {wechat_name:wechat_name,wechat_account:wechat_account,speed:speed,source:source,require_views:require_views,type:4},function (result) {
                                if(result.code == 1 )
                                {
                                    layer.close(index);
                                    layer.msg(result.msg)
                                    window.location.reload();
                                }else{
                                    layer.close(index);
                                    layer.msg(result.msg)
                                }
                            });
                    });
                }
            });
        })
        function  sumMoney() {
            var value = $("input[name='require_views']").val();
            var speed_value = $("input[name='speed']:checked").attr('data');
            var sum = value * speed_value /1000;
            sum =sum.toFixed(2)
            var count = value * speed_value;
            $("#count_").html(sum)
            $("#money_").html(sum)
        }
        //加载省数据
        function loadProvince() {
            var proHtml = '';
            for (var i = 0; i < areaData.length; i++) {
                proHtml += '<option value="' + areaData[i].provinceCode + '_' + areaData[i].mallCityList.length + '_' + i + '">' + areaData[i].provinceName + '</option>';
            }
            //初始化省数据
            $form.find('select[name=province]').append(proHtml);
            form.render();
            form.on('select(province)', function(data) {
                $form.find('select[name=area]').html('<option value="">请选择县/区</option>').parent().hide();
                var value = data.value;
                var d = value.split('_');
                var code = d[0];
                var count = d[1];
                var index = d[2];
                if (count > 0) {
                    loadCity(areaData[index].mallCityList);
                } else {
                    $form.find('select[name=city]').parent().hide();
                }
            });
        }
        //加载市数据
        function loadCity(citys) {
            var cityHtml = '';
            for (var i = 0; i < citys.length; i++) {
                cityHtml += '<option value="' + citys[i].cityCode + '_' + citys[i].mallAreaList.length + '_' + i + '">' + citys[i].cityName + '</option>';
            }
            $form.find('select[name=city]').html(cityHtml).parent().show();
            form.render();
            form.on('select(city)', function(data) {
                var value = data.value;
                var d = value.split('_');
                var code = d[0];
                var count = d[1];
                var index = d[2];
                /*if (count > 0) {
                    loadArea(citys[index].mallAreaList);
                } else {
                    $form.find('select[name=area]').parent().hide();
                }*/
            });
        }
    </script>
@endsection