@extends('Home.layout')
@section('content')
    <div class="layui-card">
        <div class="layui-card-header text-center"><h2>公众号扫码加粉(僵尸粉)说明</h2></div>
        <div class="layui-card-body layui-text layadmin-text biz_desc">
            <p class="color-notice">【关注上限】单个公众号上限20000</p>
            <p class="color-notice">【暂停说明】任务提交后，不可暂停</p>
            <p>【收费说明】价格动态波动，以提交时价格为准，费用提交时一次性收取</p>
            <p>【粉丝说明】扫码关注粉为僵尸粉</p>
        </div>
    </div>
    <div class="layui-card">
        <div class="layui-card-header">提交任务</div>
        <div class="layui-card-body">
            <form class="layui-form" lay-filter="addTaskForm">
                <div class="layui-row layui-col-space10 layui-form-item">
                    <div class="layui-col-lg9">
                        <label class="layui-form-label">任务名称：</label>
                        <div class="layui-input-block">
                            <input type="text" name="title" placeholder="请输入任务名称" autocomplete="off" class="layui-input">
                        </div>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label" style="margin-top: -9px;">公众号二维码：</label>
                    <div class="layui-upload layui-input-block">
                        <button type="button" class="layui-btn layui-btn-warm" id="imgUpload">点击上传</button>
                        <input class="layui-upload-file" type="file" accept="images/*" name="file">
                        <label type="button" class="layui-btn layui-btn-danger" style="display: none" id="imgDel">删除</label>
                        <p class="color-notice">【二维码说明】只能提交公众号二维码，提交其他二维码导致未加成功，不退不补</p>
                        <p class="color-tip" style="padding-top: 5px;">注意：上传图片只要包含二维码的部分，否则影响识别</p>
                        <div class="layui-upload-list" style="display: none">
                            <img class="layui-upload-img" id="img" style="max-width: 150px;" src="">
                        </div>
                        <input type="hidden" name="image"  value=""/>
                    </div>
                </div>
                <div class="layui-row layui-col-space10 layui-form-item">
                    <div class="layui-col-lg9">
                        <label class="layui-form-label">关注后回复：</label>
                        <div class="layui-input-block">
                            <input type="text" name="reply" placeholder="请输入回复内容" autocomplete="off" class="layui-input">
                        </div>
                    </div>
                </div>
                <div class=
                     <div class="layui-form-item">
                    <label class="layui-form-label">速度类型：</label>
                    @foreach($speeds as $k=> $item)
                        <div class="layui-input-block">
                            <input type="radio" name="speed" value="{{$item->id}}"   @if($k == 0)  checked  @endif
                            title="{{$item->name}}（<b>价格:{{$item->value}}元/千</b>{{','.$item->remark}}）" data="{{$item->value}}">
                            <div class="layui-unselect layui-form-radio layui-form-radioed">
                                <i class="layui-anim layui-icon"></i>
                                <div>{{$item->id}}（<b>价格:{{$item->value}}元/千</b>{{','.$item->remark}}）</div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="layui-form-item layui-col-md6 layui-col-sm8 layui-col-xs10 layui-col-lg6">
                    <label class="layui-form-label">总需量：</label>
                    <div class="layui-input-block">
                        <input type="number" name="require_views" placeholder="请输入期望阅读量，最低100" oninput="sumMoney()"
                               autocomplete="off" class="layui-input">
                        <p id="scoreTip" style="display: block;">
                            <input type="hidden" name="money" value="@if($user) {{$user->money}} @else  0  @endif "  data="@if($user) {{$user->id}} @endif ">
                            <span class="color-notice">总需币:<span id="count_">0</span>币 ≈ <span id="money_">0</span>元 (余额:@if($user) {{$user->money}} @else  0  @endif币)</span>
                            <a class="layui-btn layui-btn-xs layui-btn-radius" href="{{route('recharge.create')}}" style="display: inline-block;">立即充值</a>
                            <br><em class="color-notice" style="font-style: unset;">注意：任务提交后，不能暂停或撤销</em>
                        </p>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <div class="layui-btn"  id="viewTaskAdd">立即提交</div>
                    </div>
                </div>
            </form>
            <!--<div style="top: 0;left: 0;position: absolute;z-index: 1000;height: 100%;width: 100%;background-color: rgba(187,187,187,0.62)"></div>-->
        </div>
    </div>
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <div class="layui-form">
                任务ID:
                <div class="layui-input-inline">
                    <input type="number" name="id" id="id" placeholder="任务ID" class="layui-input">
                </div>
                标题：
                <div class="layui-input-inline">
                    <input type="text" name="title" id="title" placeholder="公众号名" class="layui-input">
                </div>
                公众号微信号：
                状态：
                <div class="layui-input-inline">
                    <select name="status" lay-verify="required" id="status">
                        <option value="0">所有</option>
                        <option value="1">已暂停</option>
                        <option value="2">进行中</option>
                        <option value="3">已完成</option>
                    </select>
                </div>
                <button class="layui-btn layui-btn-sm" id="memberSearch">搜索</button>
            </div>
        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @{{# if(d.status =="0"){}}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">编辑</a>
                    <span style="margin-right: 20px"></span>
                    <a class="layui-btn layui-btn-danger layui-btn-sm" lay-event="del">删除</a>
                    @{{# }}}
                </div>
            </script>
            <script type="text/html" id="avatar">
                <a href="@{{d.avatar}}" target="_blank" title="点击查看"><img src="@{{d.avatar}}" alt="" width="28" height="28"></a>
            </script>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['layer','table','form','upload'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            var upload = layui.upload;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "{{ route('wechat.zombiesDate')}}" //数据接口
                ,where:{type:3}
                ,page: true //开启分页
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID', sort: true,width:80}
                    ,{field: 'title', title: '任务名称'}
                    ,{field: 'reply', title: '关注后回复'}
                    ,{field: 'speed_id', title: '速度',templet: function(d){
                            return d.speed.name+':'+d.speed.value+'元/千'
                        }}
                    ,{field: 'price', title: '单价'}
                    ,{field: 'require_collect', title: '总需量'}
                    ,{field: 'created_at', title: '提交时间'}
                    ,{field: 'status', title: '状态', sort: true,templet: function(d){
                            if(d.status=='0'){
                                return '待接单'
                            }else if(d.status=='1'){
                                return '已暂停'
                            }else if(d.status=='2'){
                                return '进行中'
                            } else if(d.status=='3'){
                                return '已完成'
                            }
                        }}
                    ,{fixed: 'right', title: '操作', width: 120, align:'center', toolbar: '#options'}
                ]]
            });

            //上传图片
            upload.render({
                elem: '#imgUpload'
                ,url: '{{ route("wechat.scan.fans.upload") }}'
                ,multiple: false
                ,data:{"_token":"{{ csrf_token() }}",maxSize:1,file:'file'}
                ,done: function(res){
                    console.log(res);
                    if(res.code == 0){//成功
                        layer.msg('上传成功',{icon:1})
                        $("#img").attr("src",'/'+res.info);
                        $(".layui-upload-list").show();
                        $("input[name='image']").val(res.info);
                    }else{
                        layer.msg('上传失败',{icon:2})
                    }
                }
            });


            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('wechat.destroy') }}",{_method:'delete',id:data.id},function (result) {
                            if (result.code==1){
                                layer.msg(result.info);
                                obj.del(); //删除对应行（tr）的DOM结构
                            }else
                            {
                                layer.msg(result.info)
                            }
                            layer.close(index);
                        });
                    });
                } else if(layEvent === 'edit'){
                    location.href = '/wechat/'+data.id+'/edit';
                }
            });
            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("",{_method:'delete',ids:ids},function (result) {
                            if (result.code==0){
                                dataTable.reload()
                            }
                            layer.close(index);
                            layer.msg(result.msg)
                        });
                    })
                }else {
                    layer.msg('请选择删除项')
                }
            })
            //搜索
            $("#memberSearch").click(function () {
                var id = $("#id").val()
                var title = $("#title").val();
                var status = $("#status").val();
                dataTable.reload({
                    where:{id:id,title:title,status:status,type:3},
                    page:{curr:1}
                })
            })
            {{--{{ route('admin.member.destroy') }}--}}
            //提交
            $("#viewTaskAdd").click(function () {
                var title = $("input[name='title']").val();
                var image = $("input[name='image']").val();
                var speed = $("input[name='speed']:checked").val();
                var reply =  $("input[name='reply']").val();

                var require_views = $("input[name='require_views").val();
                var money = $("input[name='money").val();
                var count  = parseFloat($("#count_").html())/1000;
                var id = $("input[name='money").attr('data');
                if(!parseInt(id))
                {
                    layer.msg('请先登录');
                    setTimeout(function(){
                        parent.location.href='/login'
                    },2000);
                    return false;
                }
                if(money < count)
                {
                    layer.msg('余额不足请充值');
                    return false;
                }
                if(!title)
                {
                    layer.msg('请输入任务名称');
                    return false;
                } else if(!reply)
                {
                    layer.msg('请选择回复内容');
                    return false;
                } else if(!image)
                {
                    layer.msg('上传图片');
                    return false;
                }else if(!speed)
                {
                    layer.msg('请选择速度类型');
                    return false;
                }else if(!require_views)
                {
                    layer.msg('请输入总需量');
                    return false;
                }else{
                    layer.confirm('确认提交任务吗？', function(index){
                        $.post("{{ route('wechat.post.cron') }}"
                            ,{title:title,reply:reply,speed:speed,require_views:require_views,type:3,image:image}
                            ,function (result) {
                                if(result.code == 1 )
                                {
                                    layer.close(index);
                                    layer.msg(result.msg)
                                    window.location.reload();
                                }else{
                                    layer.close(index);
                                    layer.msg(result.msg)
                                }
                            });
                    });
                }
            });
        })
        function  sumMoney() {
            var value = $("input[name='require_views']").val();
            var speed_value = $("input[name='speed']:checked").attr('data');
            var sum = value * speed_value /1000;
            sum =sum.toFixed(2)
            var count = value * speed_value;
            $("#count_").html(sum)
            $("#money_").html(sum)
        }

    </script>
@endsection