<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>登录--粉丝团</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="format-detection" content="telephone=no">
    <link rel="stylesheet" href="/static/home//layui/css/layui.css" media="all" />
    <link rel="stylesheet" href="/css/login.css" media="all" />
    <link rel="stylesheet" href="https://cdn.bootcss.com/layer/2.3/skin/layer.css" media="all" />
</head>
<body>
<div class="video_mask"></div>
<div class="login">
    <h1>粉丝团</h1>
    <form class="layui-form" action="{{route('newadmin.login')}}" method="post">
        {{csrf_field()}}
        <div class="layui-form-item">
            <input class="layui-input" name="mobile" placeholder="登录名"  type="text" autocomplete="off" >
        </div>
        <div class="layui-form-item">
            <input class="layui-input" name="password" placeholder="密码" lay-verify="password" type="password" autocomplete="off">
        </div>
        <div class="layui-form-item form_code">
            <input class="layui-input" name="captcha" placeholder="验证码" lay-verify="required" type="text" autocomplete="off">
            <div class="code">
                <img src="{{captcha_src()}}" width="116" height="36" class="yzm" title="点击更换验证码" >
            </div>
        </div>
        <button class="layui-btn login_btn" lay-submit="" lay-filter="login">登录</button>
    </form>
</div>
<script src="/js/jquery.min.js"></script>
<script type="text/javascript" src="/static/home/layui/layui.js"></script>
<script type="text/javascript" src="https://cdn.bootcss.com/layer/2.3/layer.js"></script>
<script>

    $(function(){
        $(".yzm").click(function(){
            $(this).attr("src", "{{ captcha_src('flat') }}?_t" + Math.random());
        });
    });
    layui.use('form',function () {
        var form = layui.form;
        form.verify({
            mobile: function (value, item) { //value：表单的值、item：表单的DOM对象
                if (value) {
                    return '请输入用户名';
                }
            }
            ,password:[
                /^[\S]{5,20}$/
                ,'密码6到20位，不含空格'
            ]
        })
    });
    //信息提示
    @if(session('status'))
    layer.msg("{{session('status')}}",{icon:5});
    @endif
</script>
</body>
</html>