@extends('NewAdmin.layout')
@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <div class="layui-form">
                任务ID:
                <div class="layui-input-inline">
                    <input type="number" name="id" id="id" placeholder="任务ID" class="layui-input">
                </div>
                抖音号：
                <div class="layui-input-inline">
                    <input type="text" name="trill_id" id="trill_id" placeholder="抖音号" class="layui-input">
                </div>
                {{--  链接：
                  <div class="layui-input-inline">
                      <input type="text" name="url" id="url" placeholder="文章链接" class="layui-input">
                  </div>--}}
                状态：
                <div class="layui-input-inline">
                    <select name="status" lay-verify="required" id="status">
                        <option value="0">所有</option>
                        <option value="1">进行中</option>
                        <option value="2">已完成</option>
                    </select>
                </div>
                <button class="layui-btn layui-btn-sm" id="memberSearch">搜索</button>
            </div>
        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @{{# if(d.status =="0"){}}
                    <a class="layui-btn layui-btn-sm" lay-event="edit">编辑</a>
                    <span style="margin-right: 20px"></span>
                    <a class="layui-btn layui-btn-danger layui-btn-sm" lay-event="del">删除</a>
                    @{{# }}}
                </div>
            </script>
            <script type="text/html" id="avatar">
                <a href="@{{d.avatar}}" target="_blank" title="点击查看"><img src="@{{d.avatar}}" alt="" width="28" height="28"></a>
            </script>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['layer','table','form'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "{{ route('admin.trill.date')}}" //数据接口
                ,where:{type:1}
                ,page: true //开启分页
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID', sort: true,width:80}
                    ,{field: 'trill_id', title: '抖音ID'}
                    ,{field: 'speed_id', title: '速度',templet: function(d){
                        return d.speed.name+':'+d.speed.value+'元/百'
                    }}
                    ,{field: 'price', title: '单价'}
                    ,{field: 'require_like', title: '所需粉丝数量'}
                    ,{field: 'status', title: '已完成任务', sort: true,templet: function(d){
                        if(d.status=='0'){
                            return '待接单'
                        }else if(d.status=='1'){
                            return '进行中'
                        } else if(d.status=='2'){
                            return '已完成'
                        }
                    }}
                    ,{field: 'created_at', title: '提交时间'}
                    ,{field: 'status', title: '状态', sort: true,templet: function(d){
                        if(d.status=='0'){
                            return '待接单'
                        }else if(d.status=='1'){
                            return '进行中'
                        } else if(d.status=='2'){
                            return '已完成'
                        }
                    }}
                    ,{fixed: 'right', title: '操作', width: 120, align:'center', toolbar: '#options'}
                ]]
            });
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.trill.destroy') }}",{_method:'delete',id:data.id},function (result) {
                            if (result.code==1){
                                layer.msg(result.message);
                                obj.del(); //删除对应行（tr）的DOM结构
                            }else
                            {
                                layer.msg(result.message)
                            }
                            layer.close(index);
                        });
                    });
                } else if(layEvent === 'edit'){
                    location.href = '/newadmin/admin/trill/'+data.id+'/edit';
                }
            });
            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("",{_method:'delete',ids:ids},function (result) {
                            if (result.code==0){
                                dataTable.reload()
                            }
                            layer.close(index);
                            layer.msg(result.msg)
                        });
                    })
                }else {
                    layer.msg('请选择删除项')
                }
            })
            //搜索
            $("#memberSearch").click(function () {
                var id = $("#id").val()
                var trill_id = $("#trill_id").val();
                var url = $("#url").val();
                var status = $("#status").val();
                dataTable.reload({
                    where:{id:id,trill_id:trill_id,url:url,status:status,type:1},
                    page:{curr:1}
                })
            })
            {{--{{ route('admin.member.destroy') }}--}}
            //提交
            $("#viewTaskAdd").click(function () {
                var trill_id = $("input[name='trill_id']").val();
                var speed = $("input[name='speed']:checked").val();
                var require_like = $("input[name='require_like").val();
                var money = $("input[name='money").val();
                var count  = parseFloat($("#count_").html())/1000;
                var id = $("input[name='money").attr('data');
                if(!parseInt(id))
                {
                    layer.msg('请先登录');
                    setTimeout(function(){
                        parent.location.href='/login'
                    },2000);
                    return false;
                }
                if(money < count)
                {
                    layer.msg('余额不足请充值');
                    return false;
                }
                if(!trill_id)
                {
                    layer.msg('请输入抖音ID');
                    return false;
                }else if(!speed)
                {
                    layer.msg('请选择速度类型');
                    return false;
                }else if(!require_like)
                {
                    layer.msg('请输入需要的粉丝数量');
                    return false;
                }else if(require_like < 100)
                {
                    layer.msg('粉丝数量不能低于100');
                    return false;
                }else{
                    layer.confirm('确认提交任务吗？', function(index){
                        $.post("{{ route('trill.post.cron') }}",
                            {type:1,trill_id:trill_id,speed:speed,require_like:require_like},function (result) {
                                if(result.code == 1 )
                                {
                                    layer.close(index);
                                    layer.msg(result.msg)
                                    window.location.reload();
                                }else{
                                    layer.close(index);
                                    layer.msg(result.msg)
                                }
                            });
                    });
                }
            });
        })

        function  sumMoney() {
            var value = $("input[name='require_like']").val();
            var speed_value = $("input[name='speed']:checked").attr('data');
            var sum = value * speed_value /100;
            sum =sum.toFixed(2)
            var count = value * speed_value;
            $("#count_").html(sum)
            $("#money_").html(sum)
        }
    </script>
@endsection