<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
use Illuminate\Routing\Router;

//后台
Route::group(['prefix'=>'admin','namespace'=>'Admin','middleware'=>'logs'],function(){
    Route::get('login','LoginController@login');
    Route::post('/generateCaptcha','LoginController@generateCaptcha');
    Route::post('check','LoginController@checkLogin');
});

Route::group(['prefix'=>'admin','namespace'=>'Admin','middleware'=>['checkLogin','logs']],function(Router $router){
    $router->get('logout','LoginController@logout');
    $router->get('index','IndexController@index');
    $router->get('home','IndexController@home');

    $router->get('viewTask/readBrushOne','ViewTaskController@readBrushOne');//机刷无误1
    $router->get('viewTask/readBrushTwo','ViewTaskController@readBrushTwo');//机刷无误2
    $router->get('viewTask/readBrushThree','ViewTaskController@readBrushThree');//机刷无误3
    $router->get('viewTask/readRealPerson','ViewTaskController@readRealPerson');//真人无误1
    $router->get('vote/official','VoteController@official');//真人无误1
    $router->get('weChatTask/scan/fans','WeChatTaskController@wechatScanFans');//公众号扫码加粉
    $router->get('weChatTask/real/person','WeChatTaskController@realPersonFens');//公众号扫码加粉


    $router->get('trill/fans/{type}','TrillTaskController@trillFans');//抖音粉丝
    $router->get('trill/like/{type}','TrillTaskController@trillLike');//抖音点赞
    $router->get('trill/comment/{type}','TrillTaskController@trillComment');//抖音评论
    $router->get('trill/transmit/{type}','TrillTaskController@trillTransmit');//抖音转发
    $router->get('trill/watch/{type}','TrillTaskController@trillWatch');//抖音观看


    $router->resource('adminuser',AdminUserController::class);
    $router->resource('users',UserController::class);//会员管理
    $router->resource('category',CategoryController::class);//栏目分类
    $router->resource('setting',SettingController::class);//速度设置
    $router->resource('permission',PermissionController::class);
    $router->resource('role',RoleController::class);
    $router->resource('viewTask',ViewTaskController::class);//刷阅读
    $router->resource('weChatTask',WeChatTaskController::class);//公众号增粉
    $router->resource('vote',VoteController::class);//评论、投票、点赞
    $router->resource('recharge',RechargeController::class);//充值明细
    $router->resource('trill',TrillTaskController::class);//充值明细
    $router->post('setStatus','AdminUserController@setStatus');

//    $router->resource('dictionary',DictionaryController::class);
});


Route::get('/','Web\HomeController@index')->name('home.index');
Route::get('show','Web\HomeController@show')->name('home.show');
Route::get('login','Web\LoginController@index')->name('home.member.login');
Route::get('logout','Web\LoginController@logout')->name('home.member.logout');
Route::post('login','Web\LoginController@checkLogin')->name('home.member.login');

Route::get('register','Web\RegisterController@register')->name('home.member.register');
Route::post('register','Web\RegisterController@registerStore')->name('home.member.register');

Route::post('/getCode','Web\RegisterController@getCode');
Route::post('/registerPost','Web\RegisterController@registerPost');

/*Route::group(['namespace'=>'Web','middleware'=>['checkLogin']],function(Router $router){
    Route::get('/','Web\HomeController@index');
});*/

//刷阅读
Route::get('view/read/brush/one','Web\ViewTaskController@readBrushOne')->name('view.read.brush.one');//无误机刷1
Route::get('view/read/brush/two','Web\ViewTaskController@readBrushTwo')->name('view.read.brush.two');//无误机刷2
Route::get('view/read/brush/three','Web\ViewTaskController@readBrushThree')->name('view.read.brush.three');//无误机刷3
Route::get('view/read/reality/one','Web\ViewTaskController@readRealityOne')->name('view.read.reality.one');//真人有误1
Route::post('view/post/cron','Web\ViewTaskController@postCron')->name('view.post.cron');//提交任务
Route::get('view/read/date','Web\ViewTaskController@readBrushDate')->name('view.read.date');//数据请求接口
Route::delete('view/destroy', 'Web\ViewTaskController@destroy')->name('view.destroy');//删除评论
Route::get('view/{id}/edit', 'Web\ViewTaskController@edit')->name('view.edit');//编辑任务
Route::put('view/update', 'Web\ViewTaskController@update')->name('view.update');//提交编辑任务
//公众号增粉
Route::get('wechat/zombies','Web\WechatTaskController@zombies')->name('wechat.zombies');//僵尸粉
Route::get('wechat/zombiesDate','Web\WechatTaskController@zombiesDate')->name('wechat.zombiesDate');//数据请求接口
Route::post('wechat/post/cron','Web\WechatTaskController@postCron')->name('wechat.post.cron');//提交任务
Route::delete('wechat/destroy', 'Web\WechatTaskController@destroy')->name('wechat.destroy');//删除评论
Route::get('wechat/{id}/edit', 'Web\WechatTaskController@edit')->name('wechat.edit');//编辑任务
Route::put('wechat/update', 'Web\WechatTaskController@update')->name('wechat.update');//提交编辑任务
Route::get('wechat/scan/fans','Web\WechatTaskController@wechatScanfans')->name('wechat.scan.fans');//扫码加僵尸粉
Route::post('wechat/scan/fans/upload', 'Web\WechatTaskController@upload')->name('wechat.scan.fans.upload');//导入数据
Route::get('wechat/reality/fans','Web\WechatTaskController@wechatRealityFans')->name('wechat.reality.fans');//真人活粉(需要授权)
Route::get('wechat/online/share/reality','Web\WechatTaskController@onlineShareRealityFans')->name('wechat.online.share.reality');//线下共享纸巾真人粉
Route::get('wechat/online/share/wifi','Web\WechatTaskController@onlineShareWIFIFans')->name('wechat.online.share.wifi');//线下共享纸巾真人粉
Route::get('wechat/share/reality/fans','Web\WechatTaskController@shareRealityFans')->name('wechat.share.reality.fans');//真人活粉(无需授权)


//微信文章点赞
Route::get('vote/like','Web\VoteController@like')->name('vote.like');//微信文章点赞
Route::get('vote/likeDate','Web\VoteController@likeDate')->name('vote.likeDate');//数据请求接口
Route::post('vote/postCron','Web\VoteController@postCron')->name('vote.postCron');//提交任务
Route::delete('vote/destroy', 'Web\VoteController@destroy')->name('wechat.destroy');//删除评论
Route::get('vote/{id}/edit', 'Web\VoteController@edit')->name('vote.edit');//编辑任务
Route::put('vote/update', 'Web\VoteController@update')->name('vote.update');//提交编辑任务
Route::get('vote/small/program/fans','Web\VoteController@smallProgramFans')->name('vote.small.program.fans');//小程序扫码僵尸加粉
Route::get('vote/article/message/like','Web\VoteController@articleMessageLike')->name('vote.article.message.like');//公众号文章留言点赞
Route::get('vote/wechat/official/vote','Web\VoteController@wechatOfficialVote')->name('vote.wechat.official.vote');//微信官方投票


//抖音业务
Route::get('trill/fans','Web\TrillTaskController@trillFans')->name('trill.fans');//粉丝
Route::get('trill/like','Web\TrillTaskController@trillLike')->name('trill.like');//点赞
Route::get('trill/comment','Web\TrillTaskController@trillComment')->name('trill.comment');//评论
Route::get('trill/transmit','Web\TrillTaskController@trillTransmit')->name('trill.transmit');//转发
Route::get('trill/watch','Web\TrillTaskController@trillWatch')->name('trill.watch');//观看量
Route::post('trill/post/cron','Web\TrillTaskController@postCron')->name('trill.post.cron');//提交任务
Route::get('trill/date','Web\TrillTaskController@date')->name('trill.date');//数据请求接口
Route::delete('trill/destroy', 'Web\TrillTaskController@destroy')->name('trill.destroy');//删除评论
Route::get('trill/{id}/edit', 'Web\TrillTaskController@edit')->name('trill.edit');//编辑任务
Route::put('trill/update', 'Web\TrillTaskController@update')->name('trill.update');//提交编辑任务
//余额变化
Route::get('balance/change','Web\BalanceController@change')->name('balance.change');//余额变化记录
Route::get('balance/changeDate','Web\BalanceController@changeDate')->name('balance.changeDate');//数据请求接口

//充值
Route::get('recharge/create','Web\RechargeController@index')->name('recharge.create');//充值
Route::post('recharge/create','Web\RechargeController@store')->name('recharge.create');//
Route::post('wechat/check','Web\RechargeController@wechatCheck');//
Route::any('alipay/return','Web\RechargeController@aliReturn');//支付宝同步回调
Route::any('alipay/notify','Web\RechargeController@aliNotify');//支付宝异步回调
Route::any('wechat/notify','Web\RechargeController@wechatNotify');//微信回调


//用户资料
Route::get('member','Web\MemberController@index')->name('home.member.profile');//会员资料
Route::post('member','Web\MemberController@store')->name('home.member.profile');//会员资料提交
Route::get('member/pass','Web\MemberController@pass')->name('home.member.pass');//会员密码
Route::post('member/pass','Web\MemberController@password')->name('home.member.pass');//会员密码提交




//Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth','admin']], function () {
//新后台
Route::get('newadmin/login','NewAdmin\LoginController@index')->name('newadmin.login');
Route::get('newadmin/logout','NewAdmin\LoginController@logout')->name('newadmin.logout');
Route::post('newadmin/login','NewAdmin\LoginController@checkLogin')->name('newadmin.login');
Route::group(['prefix'=>'newadmin','namespace'=>'NewAdmin','middleware'=>'newadmin'],function(){
    //登录
//抖音业务
    Route::get('/newadmin','IndexController@index')->name('admin.index');
    Route::get('admin/trill/fans','TrillTaskController@trillFans')->name('admin.trill.fans');//粉丝
    Route::get('admin/trill/like','TrillTaskController@trillLike')->name('admin.trill.like');//点赞
    Route::get('admin/trill/comment','TrillTaskController@trillComment')->name('admin.trill.comment');//评论
    Route::get('admin/trill/transmit','TrillTaskController@trillTransmit')->name('admin.trill.transmit');//转发
    Route::get('admin/trill/watch','TrillTaskController@trillWatch')->name('admin.trill.watch');//观看量
    Route::post('admin/trill/post/cron','TrillTaskController@postCron')->name('admin.trill.post.cron');//提交任务
    Route::get('admin/trill/date','TrillTaskController@date')->name('admin.trill.date');//数据请求接口
    Route::delete('admin/trill/destroy', 'TrillTaskController@destroy')->name('admin.trill.destroy');//删除评论
    Route::get('admin/trill/{id}/edit', 'TrillTaskController@edit')->name('admin.trill.edit');//编辑任务
    Route::put('admin/trill/update', 'TrillTaskController@update')->name('admin.trill.update');//提交编辑任务
});




