<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>登录--口号帮</title>
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="format-detection" content="telephone=no">
    <link rel="stylesheet" href="/static/home//layui/css/layui.css" media="all" />
    <link rel="stylesheet" href="/css/login.css" media="all" />
    <link rel="stylesheet" href="https://cdn.bootcss.com/layer/2.3/skin/layer.css" media="all" />
</head>
<body>
<video class="video-player" preload="auto" autoplay="autoplay" loop="loop" data-height="1080" data-width="1920" height="1080" width="1920">
    
    <!-- 此视频文件为支付宝所有，在此仅供样式参考，如用到商业用途，请自行更换为其他视频或图片，否则造成的任何问题使用者本人承担，谢谢 -->
</video>
<div class="video_mask"></div>
<div class="login">
    <h1>口号帮</h1>
    <form class="layui-form" action="<?php echo e(route('home.member.login')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <div class="layui-form-item">
            <input class="layui-input" name="mobile" placeholder="手机号" lay-verify="phone|mobile" type="text" autocomplete="off" maxlength="11">
        </div>
        <div class="layui-form-item">
            <input class="layui-input" name="password" placeholder="密码" lay-verify="password" type="password" autocomplete="off">
        </div>
        <div class="layui-form-item form_code">
            <input class="layui-input" name="captcha" placeholder="验证码" lay-verify="required" type="text" autocomplete="off">
            <div class="code">
                <img src="<?php echo e(captcha_src()); ?>" width="116" height="36" class="yzm" title="点击更换验证码" >
            </div>
        </div>
        <button class="layui-btn login_btn" lay-submit="" lay-filter="login">登录</button>
    </form>
    <a href="<?php echo e(route('home.member.register')); ?>"><span style="color: white;">还没有账号，去注册</span></a>
</div>
<script src="/js/jquery.min.js"></script>
<script type="text/javascript" src="/static/home/layui/layui.js"></script>
<script type="text/javascript" src="https://cdn.bootcss.com/layer/2.3/layer.js"></script>
<script>

    $(function(){
        $(".yzm").click(function(){
            $(this).attr("src", "<?php echo e(captcha_src('flat')); ?>?_t" + Math.random());
        });
    });
    layui.use('form',function () {
        var form = layui.form;
        form.verify({
            mobile: function (value, item) { //value：表单的值、item：表单的DOM对象
                var myreg=/^[1][3,4,5,7,8,9][0-9]{9}$/;
                if (!myreg.test(value)) {
                    return '手机号不正确';
                }
            }
            ,password:[
                /^[\S]{6,20}$/
                ,'密码6到20位，不含空格'
            ]
        })
    });
    //信息提示
    <?php if(session('status')): ?>
        layer.msg("<?php echo e(session('status')); ?>",{icon:5});
    <?php endif; ?>
</script>
</body>
</html>