<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Affiliates_Views_ContactUs extends QUnit_UI_TemplatePage
{
	var $blAffiliate;

    function Affiliate_Affiliates_Views_ContactUs() {
        $this->blCommunications =& QUnit_Global::newObj('QCore_Bl_Communications');
        $this->blEmailTemplates =& QUnit_Global::newObj('QCore_EmailTemplates');
        $this->blAffiliate =& QUnit_Global::newObj('Affiliate_Merchants_Bl_Affiliate');

        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_SYSTOOLS, 'javascript:;');
        $this->navigationAddURL(L_G_CONTACTUS,'index.php?md=Affiliate_Affiliates_Views_ContactUs');
    }


    function process()
    {
        if(!empty($_POST['commited']))
        {
            switch($_POST['action'])
            {
                case 'send':
                    if($this->processSendMessage())
                        return;
                    break;
            }
        }
        $this->drawFormContactUs();
    }

    //------------------------------------------------------------------------

    function processSendMail()
    {
        if(get_magic_quotes_gpc())
        {
            $_POST['emailsubject'] = stripslashes($_POST['emailsubject']);
            $_POST['emailtext'] = stripslashes($_POST['emailtext']);
        }

        $system_email = $GLOBALS['Auth']->getSetting('Aff_system_email');

        $params = array('UserID' => $GLOBALS['Auth']->getUserID(),
                        'title' => $_POST['emailsubject'],
                        'body' => $_POST['emailtext']);

        $emaildata = $this->blEmailTemplates->getFilledEmailMessage('', $GLOBALS['Auth']->getAccountID(), 'AFF_EMAIL_CONTACT_US', $GLOBALS['Auth']->getSetting('Aff_default_lang'), $params);
        if($emaildata != false)
        {
            $params = array('accountid' => $GLOBALS['Auth']->getAccountID(),
                            'subject' => $emaildata['subject'],
                            'text' => $emaildata['text'],
                            'message_type' => MESSAGETYPE_EMAIL,
                            'userid' => $GLOBALS['Auth']->getUserID(),
                            'email' => $system_email,
                            'settings' => $GLOBALS['Auth']->getSettings(),
                            'returnpath' => $GLOBALS['Auth']->getUsernameForUser($GLOBALS['Auth']->getUserID())
                           );

            if(!$this->blCommunications->sendEmail($params))
            {
                $this->addErrorMessage(L_G_EMAILSENDFAILED);
                QCore_History::DebugMsg(WLOG_DEBUG, L_G_EMAILSENDFAILED.' ('.L_G_TO.': '.$system_email.')', __FILE__, __LINE__);
            }
            else
            {
                $this->addOkMessage(L_G_EMAILSENDOK);
                QCore_History::DebugMsg(WLOG_ACTION, L_G_EMAILSENDOK.' ('.L_G_TO.': '.$system_email.')', __FILE__, __LINE__);
                return false;
            }
        }
        else
        {
            $this->addErrorMessage(L_G_EMAILSENDFAILED);
            QCore_History::DebugMsg(WLOG_DBERROR, L_G_EMAILSENDFAILED.' ('.L_G_TO.': '.$system_email.')', __FILE__, __LINE__);
        }

        return false;
    }

    //------------------------------------------------------------------------

    function processSendMessage() {
        $dateFrom  = $dateTo = time();
        $active    = '1';
        $showToAll = '0';

        if(get_magic_quotes_gpc())
        {
            $_POST['emailsubject'] = stripslashes($_POST['emailsubject']);
            $_POST['emailtext'] = stripslashes($_POST['emailtext']);
        }

        $users = explode(",", $_POST['selectedusers']);
        $subject = $_POST['emailsubject'];
        $text = $_POST['emailtext'];

        if(empty($subject)) {
            QUnit_Messager::setErrorMessage(L_G_PZONE_ALERT_TITLE_CANOT_BE_EMPTY);
            return false;
        }
        if(empty($text)) {
            QUnit_Messager::setErrorMessage(L_G_PZONE_ALERT_CONTENT_CANOT_BE_EMPTY);
            return false;
        }

        // replace $Date and $Time for news before storing to DB
        $objCommunications =& QUnit_Global::newObj('QCore_Bl_Communications');
        $strs = array('title' => $subject, 'text' => $text);
        $strs = $objCommunications->replaceDateTime($strs);
        $subject = $strs['title'];
        $text = $strs['text'];

        $chunkedUserIDs = my_array_chunk($users, WD_MAX_PROCESSED_IDS);
        $userIDsArray = $chunkedUserIDs[0];
        $userid_str = "('".implode("','", $userIDsArray)."')";
        if($userid_str == '') return false;
        $params = array('AccountID' => $GLOBALS['Auth']->getAccountID(),
                        'userid_str' => $userid_str
                       );
        $objUsers =& QUnit_Global::newObj('QCore_Bl_Users');
        $users = $objUsers->getUsersToBroadcastMessage($params, true);

        $params = array('accountid' => $GLOBALS['Auth']->getAccountID(),
                        'subject' => $subject,
                        'text' => $text,
                        'message_type' => MESSAGETYPE_NEWS,
                        'users' => $users,
                        'datevalidfrom' => date("Y-m-d H:i:s", $dateFrom),
                        'datevalidto' => date("Y-m-d H:i:s", $dateTo),
                        'active' => $active,
                        'showtoall' => $showToAll
                       );

        if($objCommunications->insert($params) == false) return false;

        QUnit_Messager::setOkMessage(L_G_SAVE_OK);

        return false;
    }

    //------------------------------------------------------------------------

    function drawFormContactUs()
    {
        $panel_settings = QUnit_Global::newObj('Affiliate_Affiliates_Views_AffPanelSettings');
        $this->assign('a_description', L_G_AFF_CONTACTUS_DESCRIPTION);
        $this->assign('a_panel_settings', $panel_settings->loadPanelSettings('contactus'));
        $this->addContent('section_descriptions');

        $this->assign('a_user', $this->blAffiliate->loadUserInfoAsArray($GLOBALS['Auth']->getUserID()));

        $_POST['header'] = L_G_CONTACTUS;
        $_POST['action'] = 'send';

        $this->addContent('contact_us');

        return true;
    }

    //------------------------------------------------------------------------
}
?>
