<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Install_Views_Upgrade extends QUnit_UI_TemplatePage
{
    var $className = "Upgrade";
    var $model;

    function Affiliate_Install_Views_Install() {
        $this->model =& QUnit_Global::newObj('Affiliate_Install_Bl_Install');
    }

    //------------------------------------------------------------------------

    function &getView($action) {
        $viewClass = 'Affiliate_Install_Views_'.$action;
        if(!QUnit_Global::existsClass($viewClass)) {
            return $this->getView('Start');
        }
        return QUnit_Global::newObj($viewClass);

    }

    //------------------------------------------------------------------------

    function process() {

        if(file_exists($GLOBALS['PROJECT_ROOT_PATH'].'/settings/upgrade.lock')) {
            QUnit_Messager::setErrorMessage(L_G_UPGRADEISLOCK);
            return false;
        }

        $action = $_POST['action'];
        if(empty($action)) {
           $scenario =& $this->getScenario('');
           $view =& $this->getView('UpgradeStart');
           $this->showPage($view, $scenario);
        } else {
            $view =& $this->getView($action);
            $scenario =& $this->getScenario($_SESSION[SESSION_PREFIX.'installmethod']);
            if($view->process()) {
                $scenario =& $this->getScenario($_SESSION[SESSION_PREFIX.'installmethod']);
                $view = $this->getView($scenario->getNextStep($action));
            }

            $this->showPage($view, $scenario);
        }
    }

    //------------------------------------------------------------------------

    function showPage(&$view, &$scenario) {
        $this->temp_content = $view->getContent();
        return false;
        $progressBar =& QUnit_Global::newObj('Affiliate_Install_Views_ProgressBar');
        $this->temp_content .= $progressBar->process($scenario, $view->getName());

    }

    //------------------------------------------------------------------------

    function &getScenario($method) {
        $scClass = 'Affiliate_Install_Bl_Scenario'.$method;

        if(!QUnit_Global::existsClass($scClass)) {
            return $this->getScenario('');
        }
        return QUnit_Global::newObj($scClass);
    }
}
?>
