<?php
QUnit_Global::includeClass('Affiliate_Merchants_Views_Banner');

class Affiliate_Merchants_Views_BannerTearpage extends Affiliate_Merchants_Views_Banner
{
    //------------------------------------------------------------------------

    function Affiliate_Merchants_Views_BannerTearpage() {
        $this->currbannertype = 'Tearpage';
        parent::Affiliate_Merchants_Views_Banner();
    }

    function showBanner() {
        $this->assign('a_bannertemplate', 'banner_edit_tearpage.tpl.php');
        $this->assign('a_md', 'Affiliate_Merchants_Views_BannerTearpage');
        $this->assign('a_hlp', L_G_TEARPAGEBANNERHELP);
        $this->assign('a_size_msg', '('.L_G_LOADEDFROMIMAGE.')');
        $this->assign('a_type_text', L_G_BANNERTYPE_TEARPAGE);
        $this->assign('a_hide_banner_size', "1");

        $this->navigationAddURL(L_G_TEARPAGE_BANNER,'index.php?md=Affiliate_Merchants_Views_BannerLightbox');

        $this->getBannerTearpageData();

        parent::showBanner();
    }

    //------------------------------------------------------------------------

    function protectVariables()
    {
        $pvars = parent::protectVariables();
        $pvars['psourceurl'] = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);

        return $pvars;
    }

    //------------------------------------------------------------------------

    function checkCorrectness($pvars)
    {
        checkCorrectness($_POST['desturl'], $pvars['pdesturl'], L_G_DESTURL, CHECK_EMPTYALLOWED);
        checkCorrectness($_POST['name'], $pvars['pname'], L_G_BANNERNAME, CHECK_ALLOWED);
        $pvars['ptype'] = BANNERTYPE_TEARPAGE;

        // check file upload
        if($_FILES['sourcebanner_small']['name'] == '')
        {
            if($_POST['desc'] != '')
            {
                checkCorrectness($_POST['desc'], $pvars['pdesc'], L_G_SELECTIMAGE_SMALL, CHECK_EMPTYALLOWED);
            } else {
                QUnit_Messager::setErrorMessage(L_G_SELECTIMAGE_SMALL.' '.L_G_YOUHAVETOSELECTIMAGE);
                return false;
            }
        } else {
            // check if the file doesn't exist in the banners directory
            if(file_exists($GLOBALS['Auth']->getSetting('Aff_banners_dir').$_FILES['sourcebanner_small']['name'])) {
                QUnit_Messager::setErrorMessage(L_G_SPECIFIEDIMAGENAMEALREADYEXISTS);
                return false;
            } else {
                $oUpload = QUnit_Global::newObj('QUnit_Net_FileUpload',  $GLOBALS['Auth']->getSetting('Aff_banners_dir'), $_FILES['sourcebanner_small']);
                $oUpload->setAllowedTypes($GLOBALS['UPLOAD_ALLOWED_FILE_TYPES']);

                if($oUpload->handleUpload() === false) {
                    return false;
                }
                $pvars['pdesc'] = $GLOBALS['Auth']->getSetting('Aff_banners_url').$_FILES['sourcebanner_small']['name'];
            }
        }

        if($_FILES['sourcebanner_big']['name'] == '') {
            if($_POST['sourceurl'] != '')
            {
                checkCorrectness($_POST['sourceurl'], $pvars['psourceurl'], L_G_SELECTIMAGE_BIG, CHECK_EMPTYALLOWED);
            } else {
                QUnit_Messager::setErrorMessage(L_G_SELECTIMAGE_BIG.' '.L_G_YOUHAVETOSELECTIMAGE);
                return false;
            }
        } else {
            // check if the file doesn't exist in the banners directory
            if(file_exists($GLOBALS['Auth']->getSetting('Aff_banners_dir').$_FILES['sourcebanner_big']['name'])) {
                QUnit_Messager::setErrorMessage(L_G_SPECIFIEDIMAGENAMEALREADYEXISTS);
                return false;
            } else {
                $oUpload = QUnit_Global::newObj('QUnit_Net_FileUpload',  $GLOBALS['Auth']->getSetting('Aff_banners_dir'), $_FILES['sourcebanner_big']);
                $oUpload->setAllowedTypes($GLOBALS['UPLOAD_ALLOWED_FILE_TYPES']);

                if($oUpload->handleUpload() === false) {
                    return false;
                }
                $pvars['psourceurl'] = $GLOBALS['Auth']->getSetting('Aff_banners_url').$_FILES['sourcebanner_big']['name'];
            }
        }

        return $pvars;
    }

    function printListHeader() {
        $this->assign('a_list_cols', "3");
        echo '<td width="20%">'.L_G_ID.' / '.L_G_BANNERNAME.'</td>'
             .'<td>'.L_G_PICTUREURL.'</td>'
             .'<td width="80">'.L_G_ACTIONS.'</td>';
    }

    function getBannerTearpageData() {
        $query = 'select count(1) as "total" from `wd_pa_banners` where `bannertype`=10 and `deleted`=0';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            $total = 0;
            $this->assign('a_allcount',$total);
            return;
        }else {
            $total = $rs->fields['total'];
        }

        $numrows = empty($_REQUEST['numrows'])?10:$_REQUEST['numrows'];
        $_REQUEST["numrows"] = $numrows;

        $pages = ceil($total/$numrows);
        $page  = empty($_REQUEST['list_page'])?0:$_REQUEST['list_page'];
        $page  = $page>$pages?$pages:$page;
        $_REQUEST['list_page'] = $page;

        $this->assign('a_list_page',$page);
        $this->assign('a_list_pages',$pages);
        $this->assign('a_allcount',$total);
        $this->assign('a_numrows',$numrows);

        $query = 'select * from `wd_pa_banners` where `bannertype`=10 and `deleted`=0 order by `dateinserted` desc limit '.$page*$numrows.','.$numrows;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        //$this->assign('a_list_data',$rs);
        $this->listdata = $rs;
    }

    function printListData() {
        foreach($this->listdata as $row) {

            $testbutton = '<a title="'.L_G_TEST.'" href="javascript:showTearpage(\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('ad_view.png').'" /></a>';

            echo '<tr onmouseout="this.className=\'listresult\';" onmouseover="this.className=\'listresultMouseOver\'"><td>'.$row['bannerid'].'<br/><b>'.$row['name'].'</b></td>'
                .'<td>'.L_G_SELECTIMAGE_SMALL.'：<a target="_blank" href="'.$row['description'].'">'.cut_str($row['description'],35).'</a><br />'.L_G_SELECTIMAGE_BIG.'：<a target="_blank" href="'.$row['sourceurl'].'">'.cut_str($row['sourceurl'],35).'</a></td>'
                .'<td>'.$testbutton.'&nbsp;<a href="javascript:editBanner(\'Tearpage\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('edit.gif').'" border="0" width="16" height="16"></a>&nbsp;<a href="javascript:deleteBanner(\'Tearpage\',\''.$row['bannerid'].'\');"><img src="'.QUnit_UI_TemplatePage::getImage('delete.png').'" border="0" width="16" height="16"></a></td></tr>';
        }
    }

}
?>
