<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');
class Affiliate_Merchants_Views_DynamicLink extends QUnit_UI_TemplatePage {

function Affiliate_Merchants_Views_DynamicLink() {
    $this->navigationAddURL(L_G_HOME,'index.php?md=home');
    $this->navigationAddURL(L_G_TOPMENU_CAMPAIGNS,'index.php?md=Affiliate_Merchants_Views_BannerManager');
    $this->navigationAddURL(L_G_MANAGE_DYNLINK,'index.php?md=Affiliate_Merchants_Views_DynamicLink');
}

//--------------------------------------------------------------------------
function process(){
    if($GLOBALS['Auth']->getSetting('Aff_default_campaign') == '_') {
        $this->addErrorMessage(L_G_MANAGE_DYNLINKDISABLED);
        //return false;
    }
    //$this->addContent('dynamiclink_style');
    $this->addContent('dynamiclink_js');
    if($_POST['commited']=="yes"){
        switch($_REQUEST['action']) {
            case 'add': $this->processAdd();break;
            case 'edit': $this->processEdit();break;
            case 'delete': $this->processDelete(); break;
        }
        return true;
    }
    switch($_REQUEST['action']) {
        case 'add': $this->drawAddForm();break;
        case 'edit':
            $_REQUEST['id'] = preg_replace('/[\'\"]/', '', $_REQUEST['id']);
            $query = 'select * from `wd_g_dynamiclink` where `dlid`="'.$_REQUEST['id'].'"';
            $rs = $GLOBALS['db']->Query($query);
            if(!$rs || $rs->EOF) {
                $this->addErrorMessage(L_G_MANAGE_DYNLINKNOTEXISTS);
            }
            $_POST['desturl'] = $rs->fields['target'];
            $_POST['sourceurl'] = $rs->fields['subject'];
            $_POST['desc'] = $rs->fields['contentext'];
            $_POST['remark'] = $rs->fields['remark'];
            $this->assign('dlid',$_REQUEST['id']);
            $this->drawEditForm();
        break;
        default: $this->drawList();
    }

}

function processAdd() {
    $pdesturl = preg_replace('/[\'\"]/', '', $_POST['desturl']);
    $psourceurl = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);
    $premark = preg_replace('/[\'\"]/', '', $_POST['remark']);
    $pdesc = $_POST['desc'];

    $query = 'insert into `wd_g_dynamiclink` values ("%s","%s","%s","%s","%s","%s",NOW())';
    $id = QCore_Sql_DBUnit::createUniqueID('wd_g_dynamiclink','dlid');
    $query = sprintf($query,$id,'default1',$pdesturl,$psourceurl,$pdesc,$premark);
    if($this->checkInputData())
    if($GLOBALS['db']->Execute($query)===false) {
        $this->addErrorMessage(L_G_ADDFAIL);
        $_REQUEST['action'] = 'add';
        $this->drawAddForm();
        return false;
    }else{
        $this->addOKMessage(L_G_ADDSUCCESS);
        $this->assign('dlid',$id);
        $_REQUEST['action'] = 'edit';
        $this->drawEditForm();
        return true;
    }
    $this->drawAddForm();
    return true;
}

function processEdit() {
    $pdesturl = preg_replace('/[\'\"]/', '', $_POST['desturl']);
    $psourceurl = preg_replace('/[\'\"]/', '', $_POST['sourceurl']);
    $premark = preg_replace('/[\'\"]/', '', $_POST['remark']);
    $pdesc = $_POST['desc'];
    $query = 'update `wd_g_dynamiclink` set `target`="%s",`subject`="%s",`contentext`="%s",`remark`="%s" where `dlid`="%s"';
    $query = sprintf($query,$pdesturl,$psourceurl,$pdesc,$premark,$_POST['dlid']);
    if($this->checkInputData())
    if($GLOBALS['db']->Execute($query)===false) {
        $this->addErrorMessage(L_G_MODIFAIL);
    }else{
        $this->addOKMessage(L_G_MODISUCCESS);
    }
    $this->assign('dlid',$_POST['dlid']);
    $_REQUEST['action'] = 'edit';
    $this->drawEditForm();
    return true;
}

function processDelete() {
    if(is_array($_POST['checkeditems'])) {
        $query = 'delete from `wd_g_dynamiclink` where `dlid` in ("'.join('","',$_POST['checkeditems']).'")';
        $rs = $GLOBALS['db']->Execute($query);
    }
    $this->drawList();
}

function getListData() {
    $limit = 30;

    $query = 'select count(1) as "total" from `wd_g_dynamiclink` where `userid` = "default1"';
    $rs = $GLOBALS['db']->Query($query);
    $total = $rs->fields['total'];
    $totalpage = ceil($total/$limit);
    $totalpage = $totalpage<1?1:$totalpage;

    $page = (int) $_GET['page'];
    $page = $page<1?1:($page>$totalpage?$totalpage:$page);

    $start = ($page-1)*$limit;
    $this->assign('page',$page);
    $this->assign('totalpage',$totalpage);
    $this->assign('total',$total);
    $this->assign('limit',$limit);


    $query = 'select * from `wd_g_dynamiclink` where `userid`="default1" order by `insertdate` desc limit '.$start.','.$limit;
    $rs = $GLOBALS['db']->Query($query);
    if(!$rs || $rs->EOF) $this->assign('listdata',array());
    $this->assign('listdata',$rs);
}

function drawList() {
    $this->getListData();
    $this->addContent('dynamiclink_list');
}

function drawAddForm() {
    $this->assign('tabtitle',L_G_CREATE);
    $this->addContent('dynamiclink_add');
}

function drawEditForm() {
    $this->assign('tabtitle',L_G_EDIT);
    $this->addContent('dynamiclink_add');
}

function checkInputData() {
    $flg = true;
    if(empty($_POST['desturl'])){
        $flg = false;
        $this->addErrorMessage(L_G_DESTURLEMPTY);
    }

    if(empty($_POST['sourceurl'])){
        $flg = false;
        $this->addErrorMessage(L_G_SUBJECTEMPTY);
    }
    return $flg;
}

}

?>