<?php

QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Merchants_Views_PZoneArticleCates extends QUnit_UI_TemplatePage
{
    function Affiliate_Merchants_Views_PZoneArticleCates() {
        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_PZONE,'javascript:;');
		$this->navigationAddURL(L_G_PZONE_ARTICLECATES,'index.php?md=Affiliate_Merchants_Views_PZoneArticleCates');
        if($_GET['action']=='add') {
            $this->navigationAddURL(L_G_PZONE_ADDARTICLECATES,'');
        }else if($_GET['action']=='edit') {
            $this->navigationAddURL(L_G_PZONE_EDITARTICLECATES,'');
        }
    }

    //------------------------------------------------------------------------

    function process()
    {
        $this->addContent('dynamiclink_js');

        if($_POST['commited']=="yes"){
            switch($_REQUEST['action']) {
                case 'add': $this->processAdd();break;
                case 'edit': $this->processEdit();break;
                case 'delete': $this->processDelete(); break;
                default: $this->addErrorMessage(L_G_PZONE_ALERT_UNKNOWMETHOD);
            }
            return true;
        }

        switch($_REQUEST['action']) {
            case 'add': {
                return $this->drawAddForm();
            }
            case 'edit': {
                $_REQUEST['id'] = preg_replace('/[\'\"]/', '', $_REQUEST['id']);
                $query = 'select * from `wd_pz_cates` where `ID`="'.$_REQUEST['id'].'"';
                $rs = $GLOBALS['db']->Query($query);
                if(!$rs || $rs->EOF) {
                    $this->addErrorMessage(L_G_PZONE_ALERT_ARTICLECATES_NOTEXISTS);
                }
                $_POST['catename'] = $rs->fields['catename'];
                $_POST['catedesc'] = $rs->fields['catedesc'];
                $_POST['displaysort'] = $rs->fields['displaysort'];
                $_POST['show2nav'] = $rs->fields['show2nav'];
                $this->assign('id',$_REQUEST['id']);
                return $this->drawEditForm();
            }
        }

        $this->drawList();
    }

    //--------------------------------------------------------------------------


    function drawAddForm() {
        $this->assign('tabtitle',L_G_CREATE);
        $this->addContent('pzonearticlecates_edit');
    }

    //--------------------------------------------------------------------------

    function drawEditForm() {
        $this->assign('tabtitle',L_G_EDIT);
        $this->addContent('pzonearticlecates_edit');
    }

    //--------------------------------------------------------------------------

    function drawList() {
        $this->getListData();
        $this->addContent('pzonearticlecates_list');
    }

    //--------------------------------------------------------------------------

    function processAdd() {
        $catename = preg_replace('/[\'\"]/', '', $_POST['catename']);
        $catedesc = preg_replace('/[\'\"]/', '', $_POST['catedesc']);
        $displaysort = (int) $_POST['displaysort'];
        $show2nav = $_POST['show2nav']=='yes'?'yes':'no';

        $query = 'insert into `wd_pz_cates` values ("%s","%s","%s","%s",NOW(),"%s")';
        $id = QCore_Sql_DBUnit::createUniqueID('wd_pz_cates','ID');
        $query = sprintf($query,$id,$catename,$displaysort,$catedesc,$show2nav);
        if($this->checkInputData())
        if($GLOBALS['db']->Execute($query)===false) {
            $this->addErrorMessage(L_G_PZONE_ALERT_ADD_ARTICLECATES_FAIL);
            $_REQUEST['action'] = 'add';
            $this->drawAddForm();
        }else{
            $this->addOKMessage(L_G_PZONE_ALERT_ADD_ARTICLECATES_OK);
            $this->assign('id',$id);
            $_REQUEST['action'] = 'edit';
            $this->drawEditForm();
            return true;
        }
        $this->drawAddForm();
    }

    //--------------------------------------------------------------------------

    function processEdit() {
        $catename = preg_replace('/[\'\"]/', '', $_POST['catename']);
        $catedesc = preg_replace('/[\'\"]/', '', $_POST['catedesc']);
        $displaysort = (int) $_POST['displaysort'];
        $show2nav = $_POST['show2nav']=='yes'?'yes':'no';

        if($_POST['id']=='syscates') {
            $query = 'update `wd_pz_cates` set `catename`="%s",`displaysort`="%s",`show2nav`="%s" where `ID`="%s"';
            $query = sprintf($query,$catename,$displaysort,$show2nav,$_POST['id']);
        }else {
            $query = 'update `wd_pz_cates` set `catename`="%s",`catedesc`="%s",`displaysort`="%s",`show2nav`="%s" where `ID`="%s"';
            $query = sprintf($query,$catename,$catedesc,$displaysort,$show2nav,$_POST['id']);
        }
        if($this->checkInputData())
        if($GLOBALS['db']->Execute($query)===false) {
            $this->addErrorMessage(L_G_PZONE_ALERT_EDT_ARTICLECATES_FAIL);
        }else{
            $this->addOKMessage(L_G_PZONE_ALERT_EDT_ARTICLECATES_OK);
        }
        $this->assign('id',$_POST['id']);
        $_REQUEST['action'] = 'edit';
        $this->drawEditForm();
    }

    //--------------------------------------------------------------------------

    function processDelete() {
        if(is_array($_POST['checkeditems'])) {
            $skey = array_search('syscates',$_POST['checkeditems']);
            if($skey) {
                unset($_POST['checkeditems'][$skey]); //不能删除系统目录
            }

            $where = '("'.join('","',$_POST['checkeditems']).'")';
            $query = 'delete from `wd_pz_cates` where `ID` in '.$where;
            if($GLOBALS['db']->Execute($query)===false) {
                $this->addOKMessage(L_G_PZONE_ALERT_DEL_ARTICLECATES_FAIL);
            }else {
                $catesCount = count($_POST['checkeditems']);
                $query = 'update `wd_pz_posts` set `cateid`="syscates" where `cateid` in '.$where;
                $rs = $GLOBALS['db']->Execute($query);
                $this->addOKMessage(sprintf(L_G_PZONE_ALERT_DEL_ARTICLECATES_OK,$catesCount,$GLOBALS['db']->Affected_Rows()));
            }
        }
        $this->drawList();
    }

    //--------------------------------------------------------------------------

    function getListData() {
        $limit = 30;

        $query = 'select count(1) as "total" from `wd_pz_cates`';
        $rs = $GLOBALS['db']->Query($query);
        $total = $rs->fields['total'];
        $totalpage = ceil($total/$limit);
        $totalpage = $totalpage<1?1:$totalpage;

        $page = (int) $_GET['page'];
        $page = $page<1?1:($page>$totalpage?$totalpage:$page);

        $start = ($page-1)*$limit;
        $this->assign('page',$page);
        $this->assign('totalpage',$totalpage);
        $this->assign('total',$total);
        $this->assign('limit',$limit);


        $query = 'select c.*,count(p.ID) as "articlecounts" from `wd_pz_cates` c left join `wd_pz_posts` p on c.ID=p.cateid group by c.ID order by `displaysort`,`dateinserted` asc limit '.$start.','.$limit;
        $rs = $GLOBALS['db']->Query($query);
        if(!$rs || $rs->EOF) $this->assign('listdata',array());
        $this->assign('listdata',$rs);
    }

    //--------------------------------------------------------------------------

    function checkInputData() {
        $flg = true;
        if(empty($_POST['catename'])){
            $flg = false;
            $this->addErrorMessage(L_G_PZONE_ALERT_ARTICLECATES_CANOT_BE_EMPTY);
        }
        return $flg;
    }

    //--------------------------------------------------------------------------

}
?>
