<?php

QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Merchants_Views_PZoneFriendLinks extends QUnit_UI_TemplatePage
{
    function Affiliate_Merchants_Views_PZoneFriendLinks() {
        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_PZONE,'javascript:;');
        $this->navigationAddURL(L_G_PZONE_FLINKS,'index.php?md=Affiliate_Merchants_Views_PZoneFriendLinks');
        if($_GET['action']=='add') {
            $this->navigationAddURL(L_G_PZONE_ADDFLINK,'');
        }elseif($_GET['action']=='edit') {
            $this->navigationAddURL(L_G_PZONE_EDITFLINK,'');
        }else {
            $this->navigationAddURL(L_G_PZONE_FLINKLIST,'');
        }
    }

    //------------------------------------------------------------------------

    function process()
    {

        $this->addContent('dynamiclink_js');

        if($_POST['commited']=="yes"){
            switch($_REQUEST['action']) {
                case 'add': return $this->processAdd();break;
                case 'edit': return $this->processEdit();break;
                case 'delete': return $this->processDelete(); break;
                default: $this->addErrorMessage(L_G_PZONE_ALERT_UNKNOWMETHOD);
            }
        }

        switch($_REQUEST['action']) {
            case 'add': {
                return $this->drawAddForm();
            }
            case 'edit': {
                $_REQUEST['id'] = preg_replace('/[\'\"]/', '', $_REQUEST['id']);
                $query = 'select * from `wd_pz_links` where `ID`="'.$_REQUEST['id'].'"';
                $rs = $GLOBALS['db']->Query($query);
                $GLOBALS['dbrequests']++;
                if(!$rs || $rs->EOF) {
                    $this->addErrorMessage(L_G_PZONE_ALERT_LINKS_NOTEXISTS);
                }
                $_POST['sitetitle'] = $rs->fields['sitetitle'];
                $_POST['siteurl'] = $rs->fields['siteurl'];
                $_POST['logourl'] = $rs->fields['logourl'];
                $_POST['rsort'] = $rs->fields['rsort'];
                $_POST['rstatus'] = $rs->fields['rstatus'];
                $this->assign('id',$_REQUEST['id']);
                return $this->drawEditForm();
            }
        }

        //$this->assign('statusComboboxString',$this->getStatusCombo(true));
        $this->drawList();
    }

    //--------------------------------------------------------------------------


    function drawAddForm() {
        $this->assign('tabtitle',L_G_CREATE);
        $this->assign('statusComboboxString',$this->getStatusCombo());
        $this->addContent('pzonefriendlink_edit');
    }

    //--------------------------------------------------------------------------

    function drawEditForm() {
        $this->assign('tabtitle',L_G_EDIT);
        $this->assign('statusComboboxString',$this->getStatusCombo());
        $this->addContent('pzonefriendlink_edit');
    }

    //--------------------------------------------------------------------------

    function drawList() {
        //整理搜索参数，统一使用POST参数，链接和搜索表单提交为GET，删除表单提交为POST
        if(!isset($_POST['sitetitle'])) $_POST['sitetitle'] = $_GET['sitetitle'];
        if(!isset($_POST['rstatus'])) $_POST['rstatus'] = $_GET['rstatus'];
        $this->assign('searchlink','&rstatus='.$_POST['rstatus'].'&sitetitle='.$_POST['sitetitle']);

        $this->assign('statusComboboxString',$this->getStatusCombo(true));
        $this->getListData();
        $this->addContent('pzonefriendlink_list');
    }

    //--------------------------------------------------------------------------

    function processAdd() {
        $sitetitle = preg_replace('/[\'\"]/', '', strip_tags($_POST['sitetitle']));
        $siteurl = preg_replace('/[\'\"]/', '', strip_tags($_POST['siteurl']));
        $logourl = preg_replace('/[\'\"]/', '', strip_tags($_POST['logourl']));
        $rstatus = preg_replace('/[\'\"]/', '', strip_tags($_POST['rstatus']));
        $rsort = (int) $_POST['rsort'];

        $query = 'insert into `wd_pz_links` values ("%s","%s","%s","%s","%s","%s",NOW())';
        $id = QCore_Sql_DBUnit::createUniqueID('wd_pz_links','ID');
        $query = sprintf($query,$id,$sitetitle,$siteurl,$logourl,$rsort,$rstatus);
        if($this->checkInputData())
        $GLOBALS['dbrequests']++;
        if($GLOBALS['db']->Execute($query)===false) {
            $this->addErrorMessage(L_G_PZONE_ALERT_ADD_LINKS_FAIL);
            $_REQUEST['action'] = 'add';
            return $this->drawAddForm();
        }else{
            $this->addOKMessage(L_G_PZONE_ALERT_ADD_LINKS_OK.L_G_PZONE_GOON_ADD_LINKS);
            $this->assign('id',$id);
            $_REQUEST['action'] = 'edit';
            return $this->drawEditForm();
        }
        $this->drawAddForm();
    }

    //--------------------------------------------------------------------------

    function processEdit() {
        $sitetitle = preg_replace('/[\'\"]/', '', strip_tags($_POST['sitetitle']));
        $siteurl = preg_replace('/[\'\"]/', '', strip_tags($_POST['siteurl']));
        $logourl = preg_replace('/[\'\"]/', '', strip_tags($_POST['logourl']));
        $rstatus = preg_replace('/[\'\"]/', '', strip_tags($_POST['rstatus']));
        $rsort = (int) $_POST['rsort'];

        $query = 'update `wd_pz_links` set `sitetitle`="%s",`siteurl`="%s",`logourl`="%s",`rstatus`="%s",`rsort`=%d where `ID`="%s"';
        $query = sprintf($query,$sitetitle,$siteurl,$logourl,$rstatus,$rsort,$_POST['id']);
        if($this->checkInputData()) {
            $GLOBALS['dbrequests']++;
            if($GLOBALS['db']->Execute($query)===false) {
                $this->addErrorMessage(L_G_PZONE_ALERT_EDT_LINKS_FAIL);
            }else{
                $this->addOKMessage(L_G_PZONE_ALERT_EDT_LINKS_OK);
            }
        }
        $this->assign('id',$_POST['id']);
        $_REQUEST['action'] = 'edit';
        $this->drawEditForm();
    }

    //--------------------------------------------------------------------------

    function processDelete() {
        if(is_array($_POST['checkeditems'])) {
            $where = '("'.join('","',$_POST['checkeditems']).'")';
            $query = 'delete from `wd_pz_links` where `ID` in '.$where;
            $catesCount = count($_POST['checkeditems']);
            $GLOBALS['dbrequests']++;
            $rs = $GLOBALS['db']->Execute($query);
            $this->addOKMessage(sprintf(L_G_PZONE_DELETE_OK,$catesCount));
        }
        $this->drawList();
    }

    //--------------------------------------------------------------------------

    function getListData() {
        $limit = 30;

        $where = 'where 1 ';
        if(!empty($_POST['rstatus'])) $where .= ' and `rstatus`="'.$_POST['rstatus'].'"';
        if(!empty($_POST['sitetitle'])) $where .= ' and `sitetitle` like "%'.mysql_real_escape_string($_POST['sitetitle']).'%"';

        $query = 'select count(1) as "total" from `wd_pz_links` '.$where;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        $total = $rs->fields['total'];
        $totalpage = ceil($total/$limit);
        $totalpage = $totalpage<1?1:$totalpage;

        $page = (int) $_GET['page'];
        $page = $page<1?1:($page>$totalpage?$totalpage:$page);

        $start = ($page-1)*$limit;
        $this->assign('page',$page);
        $this->assign('totalpage',$totalpage);
        $this->assign('total',$total);
        $this->assign('limit',$limit);

        $query = 'select * from `wd_pz_links` '.$where.' order by `rsort`,`dateinserted` asc limit '.$start.','.$limit;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) $this->assign('listdata',array());
        $this->assign('listdata',$rs);
    }

    //--------------------------------------------------------------------------

    function getStatusCombo($isearch=false) {
        $s = '<select name="rstatus">';
        if($isearch) {
            $tmp[] = array('ID'=>0,'name'=>L_G_ALLSTATES);
        }
        $tmp[] = array('ID'=>'show','name'=>L_G_DISPLAY);
        $tmp[] = array('ID'=>'hide','name'=>L_G_HIDDEN);
        $tmp[] = array('ID'=>'show2nav','name'=>L_G_PZONE_SHOW2NAV);
        foreach($tmp as $row) {
            $ck = $_POST['rstatus']==$row['ID']?'selected="selected"':'';
            $s .= sprintf('<option value="%s" %s>%s</option>',$row['ID'],$ck,$row['name']);
        }
        $s .= '</select>';
        return $s;
    }

    //--------------------------------------------------------------------------

    function checkInputData() {
        $flg = true;
        if(empty($_POST['sitetitle'])){
            $flg = false;
            $this->addErrorMessage(L_G_PZONE_ALERT_SITETITLE_EMPTY);
        }
        if(empty($_POST['siteurl'])){
            $flg = false;
            $this->addErrorMessage(L_G_PZONE_ALERT_SITEURL_EMPTY);
        }
        $_POST['rstatus'] = !in_array($_POST['rstatus'],array('show','hide'))?'show':$_POST['rstatus'];;
        return $flg;
    }

    //--------------------------------------------------------------------------

}
?>
